/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.IObjectElementFactory;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.ObjectElementFactoryExtension;
import org.eclipse.actf.model.dom.dombycom.impl.object.QTNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.RPNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.WMP64NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.WMPNodeImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

public class ObjectElementFactory {
    private static IObjectElementFactory[] factories = ObjectElementFactoryExtension.getObjectElementFactories();

    public static NodeImpl create(NodeImpl base, IDispatch inode) {
        IObjectElementFactory[] iObjectElementFactoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IObjectElementFactory factory = iObjectElementFactoryArray[n2];
            NodeImpl newNode = factory.createTopNode(base, inode);
            if (newNode != null) {
                return newNode;
            }
            ++n2;
        }
        Object controls = Helper.get(inode, "controls");
        if (controls instanceof IDispatch) {
            return new WMPNodeImpl(base, inode, (IDispatch)controls);
        }
        Object clientID = Helper.get(inode, "ClientID");
        if (clientID != null) {
            return new WMP64NodeImpl(base, inode);
        }
        try {
            Object qtVersion = inode.invoke0("GetQuickTimeVersion");
            if (qtVersion != null) {
                return new QTNodeImpl(base, inode);
            }
        }
        catch (DispatchException dispatchException) {}
        try {
            Object rpVersion = inode.invoke0("GetVersionInfo");
            if (rpVersion != null) {
                return new RPNodeImpl(base, inode);
            }
        }
        catch (DispatchException dispatchException) {}
        return null;
    }
}

