/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws;

import org.eclipse.actf.ai.screenreader.jaws.JawsAPI;
import org.eclipse.actf.ai.screenreader.jaws.JawsPlugin;
import org.eclipse.actf.ai.voice.IVoiceEventListener;

public class JawsWindowUtil {
    private static JawsAPI jaws = JawsAPI.getInstance();
    private static IVoiceEventListener listener;
    private static JawsWindowUtil instance;

    public static JawsWindowUtil getInstance() {
        if (instance == null) {
            int handle = JawsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().handle;
            if (!JawsWindowUtil._initializeWindow(handle)) {
                return null;
            }
            instance = new JawsWindowUtil();
        }
        return instance;
    }

    private JawsWindowUtil() {
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        listener = eventListener;
    }

    public boolean JawsShowTextToWindow(String stringToSpeak, boolean bInterrupt, int index) {
        boolean ret = JawsWindowUtil._setJawsWindowText(stringToSpeak);
        if (listener != null) {
            listener.indexReceived(index);
        }
        return ret;
    }

    public boolean TakeBackControl() {
        int handle = JawsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().handle;
        return JawsWindowUtil._TakeBackControl(handle);
    }

    public static boolean callBack(int param) {
        System.err.println("Callbacked!!!" + param);
        if (listener == null) {
            return true;
        }
        if (param == 0) {
            listener.indexReceived(-1);
        } else if (param == 1) {
            jaws.JawsStopSpeech();
            JawsWindowUtil.getInstance().resetJawsWindowText();
            jaws.JawsRunScript("AiBrowserSayAllOff");
            listener.indexReceived(-2);
        }
        return true;
    }

    public void resetJawsWindowText() {
        JawsWindowUtil._resetJawsWindowText();
    }

    private static native boolean _TakeBackControl(long var0);

    private static native boolean _setJawsWindowText(String var0);

    private static native boolean _resetJawsWindowText();

    private static native boolean _initializeWindow(int var0);
}

