/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashMSAATerms;
import org.eclipse.actf.model.dom.dombycom.impl.html.ElementImpl;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.msaa.MSAA;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlashMSAANodeImpl
extends ElementImpl
implements IFlashMSAANode {
    FlashMSAAObject aObject;
    private final boolean isTop;
    private final FlashMSAANodeImpl topNode;
    protected ElementImpl base;
    private NodeImpl parent;
    private int number;

    public String getID() {
        return this.aObject.getAccKeyboardShortcut();
    }

    public int hashCode() {
        String id = this.getID();
        if (id == null) {
            return super.hashCode();
        }
        return id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IFlashMSAANode)) {
            return super.equals(o);
        }
        IFlashMSAANode msaa = (IFlashMSAANode)o;
        String id1 = this.getID();
        String id2 = msaa.getID();
        if (id1 == null || id2 == null) {
            return super.equals(o);
        }
        return id1.equals(id2);
    }

    private FlashMSAANodeImpl(ElementImpl impl, IDispatch inode, FlashMSAAObject aObject) {
        super((NodeImpl)impl, inode);
        this.base = impl;
        this.parent = null;
        this.aObject = this.searchFlash(aObject);
        this.topNode = this;
        this.isTop = true;
    }

    private FlashMSAAObject searchFlash(FlashMSAAObject top) {
        try {
            return this.searchFlash(top, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private FlashMSAAObject searchFlash(FlashMSAAObject top, int n) {
        if (top == null) {
            return null;
        }
        FlashMSAAObject[] children = top.getChildren();
        int i = 0;
        while (i < children.length) {
            IDispatch htmlElem;
            if (children[i] != null && FlashMSAAUtil.isFlash((FlashMSAAObject)children[i]) && (htmlElem = FlashMSAAUtil.getHtmlElementFromObject((Object)children[i])) != null) {
                String targetUniqueID = (String)Helper.get((IDispatch)htmlElem, (String)"uniqueID");
                String myUniqueID = this.base.getUniqueID();
                if (myUniqueID.equals(targetUniqueID)) {
                    return children[i];
                }
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            FlashMSAAObject iacc;
            if (n > 0 && (iacc = this.searchFlash(children[i], n - 1)) != null) {
                return iacc;
            }
            ++i;
        }
        return null;
    }

    private FlashMSAANodeImpl(ElementImpl msaaBase, NodeImpl parent, FlashMSAANodeImpl topNode, FlashMSAAObject aObject) {
        super((NodeImpl)msaaBase, null);
        this.base = msaaBase;
        this.aObject = aObject;
        this.parent = parent;
        this.topNode = topNode;
        this.isTop = false;
    }

    public static FlashMSAANodeImpl newMSAANode(ElementImpl impl, IDispatch inode) {
        FlashMSAAObject iacc = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)inode);
        if (iacc != null) {
            FlashMSAANodeImpl ret = new FlashMSAANodeImpl(impl, inode, iacc);
            if (ret.aObject == null) {
                return null;
            }
            return ret;
        }
        return null;
    }

    public static long getHWNDFromObject(IUnknown unknown) {
        FlashMSAAObject iacc = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)unknown);
        if (iacc == null) {
            return 0L;
        }
        return iacc.getWindow();
    }

    public Node getParentNode() {
        if (this.parent == null) {
            return super.getParentNode();
        }
        return this.parent;
    }

    public String getLinkURI() {
        return "";
    }

    public boolean doClick() {
        return this.aObject.doDefaultAction();
    }

    public NodeList getChildNodes() {
        if (this.aObject == null) {
            return new NodeListImpl(new FlashMSAAObject[0], this, this.isTop, 0);
        }
        return new NodeListImpl(this.aObject.getChildren(), this, this.isTop, 0);
    }

    public boolean hasChildNodes() {
        if (this.aObject == null) {
            return false;
        }
        return this.aObject.getChildCount() > 0;
    }

    public Node getFirstChild() {
        NodeListImpl list = new NodeListImpl(this.aObject.getChildren(), this, this.isTop, 0);
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    public Node getLastChild() {
        NodeListImpl list = new NodeListImpl(this.aObject.getChildren(), this, this.isTop, 0);
        if (list.getLength() > 0) {
            return list.item(list.getLength() - 1);
        }
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String extractString() {
        if (this.aObject == null) {
            return "";
        }
        int r = this.aObject.getAccRole();
        String accName = this.aObject.getAccName();
        if (accName == null) {
            accName = "";
        }
        if (r == 43 && accName.length() == 0) {
            accName = "" + this.number;
        }
        if (accName.length() > 0) {
            return accName;
        }
        return accName;
    }

    public String getTagName() {
        return super.getTagName();
    }

    public boolean highlight() {
        this.aObject.select(1);
        return true;
    }

    public boolean setFocus() {
        if (this.aObject == null) {
            return false;
        }
        this.aObject.select(1);
        return true;
    }

    public boolean unhighlight() {
        if (this.aObject == null) {
            return false;
        }
        this.aObject.select(16);
        return true;
    }

    public String getText() {
        return "";
    }

    public String getNodeName() {
        if (this.aObject == null) {
            return "";
        }
        String role = MSAA.getRoleText((int)this.aObject.getAccRole());
        String accName = this.aObject.getAccName();
        if (accName == null) {
            accName = "";
        }
        return "(" + role + ")" + accName;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public short getNodeType() {
        return 1;
    }

    public String getAttribute(String name) {
        return "";
    }

    public long getWindow() {
        return this.aObject.getWindow();
    }

    public AbstractTerms getTerms() {
        return FlashMSAATerms.getInstance();
    }

    private IFlashMSAANode searchByIDInternal(String id) {
        String target = this.aObject.getAccKeyboardShortcut();
        if (id.equals(target)) {
            return this;
        }
        NodeList nl = this.getChildNodes();
        int len = nl.getLength();
        int i = 0;
        while (i < len) {
            FlashMSAANodeImpl n = (FlashMSAANodeImpl)((Object)nl.item(i));
            IFlashMSAANode ret = n.searchByIDInternal(id);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public IFlashMSAANode searchByID(String id) {
        return this.topNode.searchByIDInternal(id);
    }

    public INodeEx getBaseNode() {
        return this.base;
    }

    public short getHeadingLevel() {
        if (this.isTop) {
            return super.getHeadingLevel();
        }
        return 0;
    }

    public Rectangle getLocation() {
        return this.base.getLocation();
    }

    /* synthetic */ FlashMSAANodeImpl(ElementImpl elementImpl, NodeImpl nodeImpl, FlashMSAANodeImpl flashMSAANodeImpl, FlashMSAAObject flashMSAAObject, FlashMSAANodeImpl flashMSAANodeImpl2) {
        this(elementImpl, nodeImpl, flashMSAANodeImpl, flashMSAAObject);
    }

    public static class NodeListImpl
    implements NodeList {
        ArrayList<Node> list;
        FlashMSAANodeImpl parent;
        private boolean showOffscreen = true;

        private NodeListImpl(FlashMSAAObject[] aObjects, FlashMSAANodeImpl parent, boolean isTop, int total) {
            this.parent = parent;
            this.list = new ArrayList();
            int i = 0;
            while (i < aObjects.length) {
                if (aObjects[i] != null) {
                    int accState = aObjects[i].getAccState();
                    FlashMSAANodeImpl node = null;
                    if ((accState & 0x8000) == 0) {
                        node = new FlashMSAANodeImpl(parent.base, (NodeImpl)parent, parent.topNode, aObjects[i], null);
                    } else if (this.showOffscreen && (accState & 0x10000) != 0) {
                        node = new FlashMSAANodeImpl(parent.base, (NodeImpl)parent, parent.topNode, aObjects[i], null);
                    }
                    if (node != null) {
                        node.number = total++;
                        this.list.add((Node)((Object)node));
                    }
                }
                ++i;
            }
        }

        public int getLength() {
            return this.list.size();
        }

        public Node item(int index) {
            return this.list.get(index);
        }
    }
}

