/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.net.URL;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.dombycom.IStyle;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.util.xpath.XPathCreator;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Node;

public class CurrentStylesImpl
implements ICurrentStyles {
    private static final String A_VISIBILITY = "visibility";
    private static final String A_TEXT_DECORATION = "textDecoration";
    private static final String A_TEXT_ALIGN = "textAlign";
    private static final String A_POSITION = "position";
    private static final String A_LINE_HEIGHT = "lineHeight";
    private static final String A_LETTER_SPACING = "letterSpacing";
    private static final String A_FONT_VARIANT = "fontVariant";
    private static final String A_FONT_STYLE = "fontStyle";
    private static final String A_FONT_SIZE = "fontSize";
    private static final String A_FONT_FAMILY = "fontFamily";
    private static final String A_DISPLAY = "display";
    private static final String A_COLOR = "color";
    private static final String A_BACKGROUND_REPEAT = "backgroundRepeat";
    private static final String A_BACKGROUND_COLOR = "backgroundColor";
    private static final String HREF = "href";
    private static final String TAG_A = "A";
    private final String xpath;
    private final String tagName;
    private final Rectangle rect;
    private final String backgroundColor;
    private final String backgroundRepeat;
    private final String color;
    private final String fontFamily;
    private final String fontSize;
    private final String fontStyle;
    private final String fontVariant;
    private final String lineHeight;
    private final String textAlign;
    private final String visibility;
    private final String display;
    private final String position;
    private final String textDecoration;
    private final String letterSpacing;
    private boolean isLink;
    private URL target = null;

    public CurrentStylesImpl(IElementEx element, URL baseUrl) {
        String href;
        this.rect = element.getLocation();
        this.xpath = XPathCreator.childPathSequence((Node)element);
        this.tagName = element.getTagName();
        this.isLink = false;
        if (TAG_A.equalsIgnoreCase(this.tagName) && (href = element.getAttribute(HREF)) != null) {
            if (baseUrl != null) {
                try {
                    this.target = new URL(baseUrl, href);
                    this.isLink = true;
                }
                catch (Exception exception) {
                    try {
                        this.target = new URL(href);
                        this.isLink = true;
                    }
                    catch (Exception exception2) {}
                }
            } else {
                try {
                    this.target = new URL(href);
                    this.isLink = true;
                }
                catch (Exception exception) {}
            }
        }
        IStyle style = element.getStyle();
        this.backgroundColor = (String)style.get(A_BACKGROUND_COLOR);
        this.backgroundRepeat = (String)style.get(A_BACKGROUND_REPEAT);
        this.color = (String)style.get(A_COLOR);
        this.display = (String)style.get(A_DISPLAY);
        this.fontFamily = (String)style.get(A_FONT_FAMILY);
        this.fontSize = (String)style.get(A_FONT_SIZE);
        this.fontStyle = (String)style.get(A_FONT_STYLE);
        this.fontVariant = (String)style.get(A_FONT_VARIANT);
        this.letterSpacing = (String)style.get(A_LETTER_SPACING);
        this.lineHeight = (String)style.get(A_LINE_HEIGHT);
        this.position = (String)style.get(A_POSITION);
        this.textAlign = (String)style.get(A_TEXT_ALIGN);
        this.textDecoration = (String)style.get(A_TEXT_DECORATION);
        this.visibility = (String)style.get(A_VISIBILITY);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public String getColor() {
        return this.color;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getLetterSpacing() {
        return this.letterSpacing;
    }

    public String getLineHeight() {
        return this.lineHeight;
    }

    public String getPosition() {
        return this.position;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public String getTextDecoration() {
        return this.textDecoration;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getXPath() {
        return this.xpath;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    public URL getLinkURL() {
        return this.target;
    }

    public boolean isLink() {
        return this.isLink;
    }
}

