/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.editors.ie;

import java.net.URI;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.events.INewWiondow2EventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.IWindowClosedEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NewWindow2Parameters;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.DummyEditorInput;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WebBrowserEventUtil;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class WebBrowserEditor
extends EditorPart
implements IModelServiceHolder {
    private static final String ABOUT_BLANK = "about:blank";
    public static final String ID = WebBrowserEditor.class.getName();
    private boolean hasIde = Platform.getBundle((String)"org.eclipse.ui.ide") != null;
    WebBrowserIEImpl webBrowser;
    IEditorInput input;

    public void createPartControl(Composite parent) {
        URI uri;
        String targetUrl = ABOUT_BLANK;
        if (this.input instanceof DummyEditorInput) {
            targetUrl = ((DummyEditorInput)this.input).getUrl();
            if ("".equals(targetUrl)) {
                targetUrl = ABOUT_BLANK;
            }
        } else if (this.input instanceof IPathEditorInput) {
            targetUrl = ((IPathEditorInput)this.input).getPath().toFile().getAbsolutePath();
        } else if (this.hasIde && this.input instanceof IURIEditorInput && (uri = ((IURIEditorInput)this.input).getURI()) != null) {
            targetUrl = uri.toString();
        }
        this.webBrowser = new WebBrowserIEImpl(this, parent, targetUrl);
        this.webBrowser.setNewWindow2EventListener(new INewWiondow2EventListener(){

            public void newWindow2(NewWindow2Parameters param) {
                IEditorPart newEditor = ModelServiceUtils.launch((String)WebBrowserEditor.ABOUT_BLANK, (String)ID);
                if (newEditor instanceof WebBrowserEditor) {
                    IWebBrowserACTF browser = (IWebBrowserACTF)((WebBrowserEditor)newEditor).getModelService();
                    param.setBrowserAddress(browser.getBrowserAddress());
                    WebBrowserEventUtil.newWindow((IWebBrowserACTF)browser);
                }
            }
        });
        this.webBrowser.setWindowClosedEventListener(new IWindowClosedEventListener(){

            public void windowClosed() {
                IWorkbenchPage page = PlatformUIUtil.getActivePage();
                if (page != null) {
                    IEditorReference[] editorRefs;
                    IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
                    int n = editorRefs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference i = iEditorReferenceArray[n2];
                        if (WebBrowserEditor.this == i.getEditor(false)) {
                            PlatformUIUtil.getActivePage().closeEditor((IEditorPart)WebBrowserEditor.this, false);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void dispose() {
        WebBrowserEventUtil.browserDisposed((IWebBrowserACTF)this.webBrowser, (String)this.getPartName());
    }

    public void setFocus() {
        WebBrowserEventUtil.getFocus((IWebBrowserACTF)this.webBrowser);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.input = input;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IModelService getModelService() {
        return this.webBrowser;
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public void setEditorTitle(String title) {
        this.setPartName(title);
    }
}

