/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkListener;

public class ChunkDecoder
extends FilterInputStream {
    static final Logger LOGGER = Logger.getLogger(ChunkDecoder.class);
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final int EOF = -1;
    private int fChunkSize = 0;
    private int fNumChunk = 0;
    private int fReadBytes = 0;
    private long fLastReadTime = 0L;
    private ChunkListener fChunkListener = null;

    public ChunkDecoder(InputStream in) {
        super(in);
    }

    public void setChunkListener(ChunkListener l) {
        if (this.fChunkListener != null && l != null) {
            throw new IllegalStateException("ChunkListener is already set: " + this.fChunkListener);
        }
        this.fChunkListener = l;
    }

    public int getChunkSize() {
        if (this.fReadBytes == 0) {
            throw new IllegalStateException("ChunkSize is unknown");
        }
        return this.fChunkSize;
    }

    /*
     * Unable to fully structure code
     */
    private int getAvailableInput(long timeout) throws IOException, TimeoutException {
        while (true) {
            try {
                data = this.in.read();
            }
            catch (SocketTimeoutException v0) {
                if (timeout <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime > timeout) ** break;
                continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException("HTTPReader.getAvailableInput");
            }
            break;
        }
        this.fLastReadTime = System.currentTimeMillis();
        return data;
    }

    private int getAvailableInput(long timeout, byte[] b, int off, int len) throws IOException, TimeoutException {
        int available;
        if (len <= 0) {
            return 0;
        }
        int nread = 0;
        while ((available = this.in.available()) <= 0) {
            if (available < 0) {
                return -1;
            }
            try {
                int data = this.in.read();
                b[off++] = (byte)data;
                nread = 1;
                --len;
                available = this.in.available();
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (timeout <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime <= timeout) continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException();
            }
        }
        if (available == 0) {
            return nread;
        }
        if (len > available) {
            len = available;
        }
        int read = this.in.read(b, off, len);
        this.fLastReadTime = System.currentTimeMillis();
        return read + nread;
    }

    private String readChunkSizeLine(long timeout) throws IOException, TimeoutException {
        int data = this.getAvailableInput(timeout);
        if (data == -1) {
            return null;
        }
        boolean cr = false;
        boolean crlf = false;
        StringBuffer token = new StringBuffer();
        while (data != -1) {
            switch (data) {
                case 13: {
                    cr = true;
                    break;
                }
                case 10: {
                    if (cr) {
                        crlf = true;
                        break;
                    }
                }
                case 9: 
                case 32: 
                case 59: {
                    cr = false;
                    break;
                }
                default: {
                    cr = false;
                    token.append((char)data);
                }
            }
            if (crlf) {
                if (token.length() > 0) break;
                cr = false;
                crlf = false;
            }
            data = this.getAvailableInput(timeout);
        }
        return token.toString();
    }

    private void readChunkSize(long timeout) throws IOException, TimeoutException {
        String token = this.readChunkSizeLine(timeout);
        ++this.fNumChunk;
        if (token == null || token.length() == 0) {
            this.fChunkSize = -1;
        } else {
            token = token.trim();
            try {
                this.fChunkSize = Integer.parseInt(token, 16);
                if (this.fChunkListener != null) {
                    this.fChunkListener.newChankRead(this.fNumChunk, this.fChunkSize);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fChunkSize = -1;
                throw new IOException("Invalid chunk size line: '" + token + "'");
            }
        }
    }

    public int read(long timeout) throws IOException, TimeoutException {
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            this.readChunkSize(timeout);
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return -1;
        }
        int data = this.getAvailableInput(timeout);
        ++this.fReadBytes;
        return data;
    }

    public int read() throws IOException {
        try {
            return this.read(0L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public int read(long timeout, byte[] b, int off, int len) throws IOException, TimeoutException {
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            this.readChunkSize(timeout);
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return -1;
        }
        int max = this.fChunkSize - this.fReadBytes;
        if (len > max) {
            len = max;
        }
        int read = this.getAvailableInput(timeout, b, off, len);
        this.fReadBytes += read;
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.read(0L, b, off, len);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() throws IOException {
        int left;
        int available = this.in.available();
        if (available <= 0) {
            return available;
        }
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            try {
                this.readChunkSize(1L);
            }
            catch (TimeoutException timeoutException) {
                return 0;
            }
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return 0;
        }
        available = this.in.available();
        return available < (left = this.fChunkSize - this.fReadBytes) ? available : left;
    }

    public long skip(long n) throws IOException {
        long i = 0L;
        while (i < n) {
            int data = this.read();
            if (data < 0) {
                return i;
            }
            ++i;
        }
        return n;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }
}

