/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.TextContentDescriber;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class XMLContentDescriber
extends TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING = "encoding=";
    private static final String XML_PREFIX = "<?xml ";
    private static final String XML_DECL_END = "?>";

    public int describe(InputStream input, IContentDescription description) throws IOException {
        byte[] bom = Util.getByteOrderMark(input);
        String xmlDeclEncoding = "UTF-8";
        input.reset();
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                xmlDeclEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                xmlDeclEncoding = "UTF-16LE";
            }
            input.skip(bom.length);
            if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, bom);
            }
        }
        return this.internalDescribe(this.readXMLDecl(input, xmlDeclEncoding), description);
    }

    public int describe(Reader input, IContentDescription description) throws IOException {
        return this.internalDescribe(this.readXMLDecl(input), description);
    }

    private int internalDescribe(String line, IContentDescription description) throws IOException {
        if (line == null) {
            return 1;
        }
        if (!line.startsWith(XML_PREFIX)) {
            return 1;
        }
        if (description == null) {
            return 2;
        }
        if (description.isRequested(IContentDescription.CHARSET)) {
            String charset = this.getCharset(line);
            if (charset != null && !this.isCharsetValid(charset)) {
                return 0;
            }
            if (charset != null && !charset.equalsIgnoreCase("utf8") && !charset.equalsIgnoreCase("utf-8")) {
                description.setProperty(IContentDescription.CHARSET, charset);
            }
        }
        return 2;
    }

    private boolean isFullXMLDecl(String xmlDecl) {
        return xmlDecl.endsWith(XML_DECL_END);
    }

    private String readXMLDecl(InputStream input, String encoding) throws IOException {
        byte[] xmlDeclEndBytes = XML_DECL_END.getBytes(encoding);
        int xmlDeclSize = 100 * xmlDeclEndBytes.length / 2;
        byte[] xmlDecl = new byte[xmlDeclSize];
        int c = 0;
        int read = 0;
        int count = 0;
        while (read < xmlDecl.length && (c = input.read()) != -1) {
            count = c == xmlDeclEndBytes[count] ? ++count : 0;
            xmlDecl[read++] = (byte)c;
            if (count == xmlDeclEndBytes.length) break;
        }
        return new String(xmlDecl, 0, read, encoding);
    }

    private String readXMLDecl(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        String xmlDecl = new String();
        String line = null;
        while (xmlDecl.length() < 100 && (line = reader.readLine()) != null) {
            xmlDecl = String.valueOf(xmlDecl) + line;
            if (line.indexOf(XML_DECL_END) == -1) continue;
            return xmlDecl.substring(0, xmlDecl.indexOf(XML_DECL_END) + XML_DECL_END.length());
        }
        return xmlDecl;
    }

    private String getCharset(String firstLine) {
        int encodingPos = firstLine.indexOf(ENCODING);
        if (encodingPos == -1) {
            return null;
        }
        int quoteChar = 34;
        int firstQuote = firstLine.indexOf(quoteChar, encodingPos);
        if (firstQuote == -1) {
            quoteChar = 39;
            firstQuote = firstLine.indexOf(quoteChar, encodingPos);
        }
        if (firstQuote == -1 || firstLine.length() == firstQuote - 1) {
            return null;
        }
        int secondQuote = firstLine.indexOf(quoteChar, firstQuote + 1);
        if (secondQuote == -1) {
            return this.isFullXMLDecl(firstLine) ? firstLine.substring(firstQuote + 1, firstLine.lastIndexOf(XML_DECL_END)).trim() : null;
        }
        return firstLine.substring(firstQuote + 1, secondQuote);
    }

    private boolean isCharsetValid(String charset) {
        if (charset.length() == 0) {
            return false;
        }
        char c = charset.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int i = 1;
        while (i < charset.length()) {
            c = charset.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

