/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.actf.util.command.CLArgumentException;
import org.eclipse.actf.util.command.CLSwitch;

public class CLArgumentProcessor {
    private Map _switchMap;
    private String _preUsage;
    private String _postUsage;
    private boolean _preserveCase = false;

    public CLArgumentProcessor() {
        this(new CLSwitch[0]);
    }

    public CLArgumentProcessor(CLSwitch[] switches) {
        this.setSwitches(switches);
    }

    public CLArgumentProcessor(boolean preserveCase) {
        this(new CLSwitch[0]);
        this._preserveCase = preserveCase;
    }

    public CLArgumentProcessor(CLSwitch[] switches, boolean preserveCase) {
        this._preserveCase = preserveCase;
        this.setSwitches(switches);
    }

    public CLSwitch getSwitch(String name) {
        if (this._preserveCase) {
            return (CLSwitch)this._switchMap.get(name);
        }
        return (CLSwitch)this._switchMap.get(name.toLowerCase());
    }

    public CLSwitch[] getSwitches() {
        return this._switchMap.values().toArray(new CLSwitch[this._switchMap.size()]);
    }

    public void setSwitches(CLSwitch[] switches) {
        if (this._switchMap == null) {
            this._switchMap = new HashMap();
        } else {
            this._switchMap.clear();
        }
        int s = 0;
        while (switches != null && s < switches.length) {
            if (this._preserveCase) {
                this._switchMap.put(switches[s].getName(), switches[s]);
            } else {
                this._switchMap.put(switches[s].getName().toLowerCase(), switches[s]);
            }
            ++s;
        }
    }

    public void addSwitch(CLSwitch s) {
        if (this._preserveCase) {
            this._switchMap.put(s.getName(), s);
        } else {
            this._switchMap.put(s.getName().toLowerCase(), s);
        }
    }

    public CLSwitch removeSwitch(String name) {
        if (this._preserveCase) {
            return (CLSwitch)this._switchMap.remove(name);
        }
        return (CLSwitch)this._switchMap.remove(name.toLowerCase());
    }

    public void processArguments(String[] args) throws CLArgumentException {
        if (args.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        int arg = 0;
        while (arg < args.length) {
            block12: {
                String name = this.nameIfValidSwitch(args[arg]);
                if (name == null) {
                    System.err.println("Unknown switch: " + args[arg]);
                } else {
                    CLSwitch clSwitch = this.getSwitch(name);
                    if (clSwitch.getValueType().equals(Boolean.class) || clSwitch.getValueType().equals(Boolean.TYPE)) {
                        clSwitch.setValue("__true__");
                    } else {
                        StringBuffer argBuff = new StringBuffer();
                        int start = arg;
                        int numArgs = clSwitch.getExpectedNumberOfArgs();
                        while (++arg < args.length && arg - start <= numArgs & this.nameIfValidSwitch(args[arg]) == null) {
                            argBuff.append(args[arg]);
                            argBuff.append(' ');
                        }
                        if (arg < args.length && arg - start > numArgs && this.nameIfValidSwitch(args[arg]) == null) {
                            do {
                                System.err.println("Ignoring argument: " + args[arg] + " - beyond expected number of args for switch " + clSwitch.getName());
                                if (Character.isLetter(args[arg].charAt(0))) continue;
                                System.err.println("May be unknown switch: " + args[arg]);
                            } while (++arg < args.length && this.nameIfValidSwitch(args[arg]) == null);
                        }
                        try {
                            clSwitch.resolveValue(argBuff.toString().trim());
                        }
                        catch (Exception exception) {
                            System.err.println("Warning: could not resolve argument " + argBuff.toString() + " for switch " + clSwitch.getName() + " to type " + clSwitch.getValueType().getName());
                            --arg;
                            break block12;
                        }
                        --arg;
                    }
                }
            }
            ++arg;
        }
        for (CLSwitch cls : this._switchMap.values()) {
            if (!cls.isRequired() || cls.getResolvedValue() != null) continue;
            throw new CLArgumentException("Switch " + cls.getName() + " is required and has not been set");
        }
    }

    public int getIntArgument(String name) throws CLArgumentException {
        CLSwitch clSwitch = this.getSwitch(name);
        int val = -1;
        if (clSwitch != null) {
            if (clSwitch.getResolvedValue() != null && (Integer.class.isAssignableFrom(clSwitch.getValueType()) || clSwitch.getValueType().equals(Integer.TYPE))) {
                val = (Integer)clSwitch.getResolvedValue();
            } else {
                throw new CLArgumentException("Switch " + clSwitch.getName() + " does not have an associated value of type int");
            }
        }
        return val;
    }

    public long getLongArgument(String name) throws CLArgumentException {
        CLSwitch clSwitch = this.getSwitch(name);
        long val = -1L;
        if (clSwitch != null) {
            if (clSwitch.getResolvedValue() != null && (Long.class.isAssignableFrom(clSwitch.getValueType()) || clSwitch.getValueType().equals(Long.TYPE))) {
                val = (Long)clSwitch.getResolvedValue();
            } else {
                throw new CLArgumentException("Switch " + clSwitch.getName() + " does not have an associated value of type long");
            }
        }
        return val;
    }

    public float getFloatArgument(String name) throws CLArgumentException {
        CLSwitch clSwitch = this.getSwitch(name);
        float val = -1.0f;
        if (clSwitch != null) {
            if (clSwitch.getResolvedValue() != null && (Float.class.isAssignableFrom(clSwitch.getValueType()) || clSwitch.getValueType().equals(Float.TYPE))) {
                val = ((Float)clSwitch.getResolvedValue()).floatValue();
            } else {
                throw new CLArgumentException("Switch " + clSwitch.getName() + " does not have an associated value of type float");
            }
        }
        return val;
    }

    public double getDoubleArgument(String name) throws CLArgumentException {
        CLSwitch clSwitch = this.getSwitch(name);
        double val = -1.0;
        if (clSwitch != null) {
            if (clSwitch.getResolvedValue() != null && (Double.class.isAssignableFrom(clSwitch.getValueType()) || clSwitch.getValueType().equals(Double.TYPE))) {
                val = ((Number)clSwitch.getResolvedValue()).doubleValue();
            } else {
                throw new CLArgumentException("Switch " + clSwitch.getName() + " does not have an associated value of type double");
            }
        }
        return val;
    }

    public boolean getBooleanArgument(String name) throws CLArgumentException {
        CLSwitch clSwitch = this.getSwitch(name);
        boolean val = false;
        if (clSwitch != null) {
            if (Boolean.class.isAssignableFrom(clSwitch.getValueType()) || clSwitch.getValueType().equals(Boolean.TYPE)) {
                val = clSwitch.getResolvedValue() != null && (Boolean)clSwitch.getResolvedValue() != false;
            } else {
                throw new CLArgumentException("Switch " + clSwitch.getName() + " does not have an associated value of type bool");
            }
        }
        return val;
    }

    public Object getArgument(String name) {
        CLSwitch s = this.getSwitch(name);
        return s == null ? null : s.getResolvedValue();
    }

    public String nameIfValidSwitch(String sw) {
        int index = 0;
        String res = null;
        while (index < sw.length() && !Character.isLetter(sw.charAt(index++))) {
        }
        String prefix = sw.substring(0, index - 1);
        String name = sw.substring(index - 1);
        CLSwitch clSwitch = this.getSwitch(name);
        if (clSwitch != null) {
            if (this._preserveCase && clSwitch.getFullSwitchName().equals(String.valueOf(prefix) + name)) {
                res = name;
            } else if (!this._preserveCase && clSwitch.getFullSwitchName().equalsIgnoreCase(String.valueOf(prefix) + name)) {
                res = name;
            }
        }
        return res;
    }

    public void prependToUsage(String pre) {
        this._preUsage = pre;
    }

    public void appendToUsage(String post) {
        this._postUsage = post;
    }

    protected void printUsage() {
        Iterator iter = this._switchMap.values().iterator();
        System.out.println(this._preUsage == null ? "" : this._preUsage);
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        while (iter.hasNext()) {
            CLSwitch clSwitch = (CLSwitch)iter.next();
            System.out.print(String.valueOf(clSwitch.getFullSwitchName()) + " " + clSwitch.getDescription());
            System.out.print(clSwitch.isRequired() ? " [required] " : " ");
            System.out.println(clSwitch.getDefaultValue() != null ? " {default=" + clSwitch.getDefaultValue() + "}" : "");
        }
        System.out.println();
        System.out.println(this._postUsage == null ? "" : this._postUsage);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        Iterator iter = this._switchMap.values().iterator();
        sb.append(":\n");
        while (iter.hasNext()) {
            CLSwitch s = (CLSwitch)iter.next();
            Object val = s.getResolvedValue();
            sb.append(s.getFullSwitchName());
            sb.append('[');
            sb.append("arg:" + s.getValue());
            sb.append(',');
            sb.append("resolved:");
            sb.append(val == null ? "<unresolved>" : val.toString());
            if (val != null) {
                sb.append(',');
                sb.append("type:" + s.getResolvedValue().getClass().getName());
            }
            sb.append(']');
            sb.append('\n');
        }
        return sb.toString();
    }
}

