/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.actf.util.logging.AbstractErrorLogger;

public class StreamErrorLogger
extends AbstractErrorLogger {
    private PrintWriter _writer;
    private String _filename;

    public StreamErrorLogger(OutputStream stream) {
        this._writer = new PrintWriter((Writer)new OutputStreamWriter(stream), true);
    }

    public void logError(String msg, Throwable t) {
        if (msg != null) {
            this._writer.println(msg);
        }
        if (t != null) {
            this._writer.println(String.valueOf(t.getClass().getName()) + " - " + t.toString());
            t.printStackTrace();
            while ((t = t.getCause()) != null) {
                this._writer.println(t.toString());
                t.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String name) {
        this._filename = name;
    }

    protected void finalize() throws Throwable {
        this._writer.close();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + (this._filename == null ? "" : this._filename) + "]";
    }
}

