/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyForStatement2;
import org.eclipse.dltk.ruby.ast.RubyIfStatement;
import org.eclipse.dltk.ruby.ast.RubyUnlessStatement;
import org.eclipse.dltk.ruby.ast.RubyUntilStatement;
import org.eclipse.dltk.ruby.ast.RubyWhileStatement;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.internal.parser.RubySourceElementParser;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinBuildVisitor;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.typeinference.LocalVariableInfo;
import org.eclipse.dltk.ruby.typeinference.OffsetTargetedASTVisitor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.IInstanceContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.dltk.ti.types.RecursionTypeCall;

public class RubyTypeInferencingUtils {
    public static IType[] getAllTypes(ISourceModule module, String prefix) {
        final ArrayList types = new ArrayList();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                IType type = match.getType();
                if (type.getParent() instanceof ISourceModule) {
                    types.add(type);
                }
            }
        };
        ScriptModelUtil.searchTypeDeclarations((IScriptProject)module.getScriptProject(), (String)(String.valueOf(prefix) + "*"), (TypeNameMatchRequestor)requestor);
        return types.toArray(new IType[types.size()]);
    }

    public static ASTNode[] getAllStaticScopes(ModuleDeclaration rootNode, int requestedOffset) {
        final ArrayList<ModuleDeclaration> scopes = new ArrayList<ModuleDeclaration>();
        OffsetTargetedASTVisitor visitor = new OffsetTargetedASTVisitor(requestedOffset){

            public boolean visitInteresting(MethodDeclaration s) {
                scopes.add(s);
                return true;
            }

            public boolean visitInteresting(ModuleDeclaration s) {
                scopes.add(s);
                return true;
            }

            public boolean visitInteresting(TypeDeclaration s) {
                scopes.add(s);
                return true;
            }
        };
        try {
            rootNode.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            RubyPlugin.log(e);
        }
        if (scopes.size() == 0) {
            scopes.add(rootNode);
        }
        return scopes.toArray(new ASTNode[scopes.size()]);
    }

    public static IMixinElement[] getModelStaticScopes(MixinModel model, ModuleDeclaration rootNode, int requestedOffset) {
        String[] modelStaticScopesKeys = RubyTypeInferencingUtils.getModelStaticScopesKeys(model, rootNode, requestedOffset);
        IMixinElement[] result = new IMixinElement[modelStaticScopesKeys.length];
        int i = 1;
        while (i < modelStaticScopesKeys.length) {
            result[i] = model.get(modelStaticScopesKeys[i]);
            ++i;
        }
        return result;
    }

    public static String[] getModelStaticScopesKeys(MixinModel model, ModuleDeclaration rootNode, int requestedOffset) {
        ASTNode[] allStaticScopes = RubyTypeInferencingUtils.getAllStaticScopes(rootNode, requestedOffset);
        return RubyMixinBuildVisitor.restoreScopesByNodes(allStaticScopes);
    }

    public static RubyClassType determineSelfClass(IContext context, int keyOffset) {
        if (context instanceof IInstanceContext) {
            IInstanceContext instanceContext = (IInstanceContext)context;
            return (RubyClassType)instanceContext.getInstanceType();
        }
        ISourceModuleContext basicContext = (ISourceModuleContext)context;
        return RubyTypeInferencingUtils.determineSelfClass(basicContext.getSourceModule(), basicContext.getRootNode(), keyOffset);
    }

    public static RubyClassType determineSelfClass(ISourceModule sourceModule, ModuleDeclaration rootNode, int keyOffset) {
        RubyMixinModel rubyModel = RubyMixinModel.getInstance();
        String[] keys = RubyTypeInferencingUtils.getModelStaticScopesKeys(rubyModel.getRawModel(), rootNode, keyOffset);
        if (keys != null && keys.length > 0) {
            String inner = keys[keys.length - 1];
            IRubyMixinElement rubyElement = rubyModel.createRubyElement(inner);
            if (rubyElement instanceof RubyMixinMethod) {
                RubyMixinMethod method = (RubyMixinMethod)rubyElement;
                return new RubyClassType(method.getSelfType().getKey());
            }
            if (rubyElement instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)rubyElement;
                return new RubyClassType(rubyMixinClass.getKey());
            }
        }
        return null;
    }

    public static RubyAssignment[] findLocalVariableAssignments(final ASTNode scope, final ASTNode nextScope, final String varName) {
        final ArrayList assignments = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration s) throws Exception {
                return s == scope;
            }

            public boolean visit(TypeDeclaration s) throws Exception {
                return s == scope;
            }

            public boolean visit(ASTNode node) throws Exception {
                VariableReference varRef;
                RubyAssignment assignment;
                ASTNode lhs;
                if (node instanceof RubyAssignment && (lhs = (assignment = (RubyAssignment)node).getLeft()) instanceof VariableReference && varName.equals((varRef = (VariableReference)lhs).getName())) {
                    assignments.add(assignment);
                }
                return node != nextScope;
            }
        };
        try {
            scope.traverse(visitor);
        }
        catch (Exception e) {
            RubyPlugin.log(e);
        }
        return assignments.toArray(new RubyAssignment[assignments.size()]);
    }

    public static boolean isRootLocalScope(ASTNode node) {
        return node instanceof ModuleDeclaration || node instanceof TypeDeclaration || node instanceof MethodDeclaration;
    }

    public static IEvaluatedType combineTypes(Collection evaluaedTypes) {
        HashSet types = new HashSet(evaluaedTypes);
        types.remove(null);
        if (types.size() > 1 && types.contains(RecursionTypeCall.INSTANCE)) {
            types.remove(RecursionTypeCall.INSTANCE);
        }
        return RubyTypeInferencingUtils.combineUniqueTypes(types.toArray(new IEvaluatedType[types.size()]));
    }

    private static IEvaluatedType combineUniqueTypes(IEvaluatedType[] types) {
        if (types.length == 0) {
            return UnknownType.INSTANCE;
        }
        if (types.length == 1) {
            return types[0];
        }
        return new AmbiguousType(types);
    }

    public static IEvaluatedType combineTypes(IEvaluatedType[] evaluaedTypes) {
        return RubyTypeInferencingUtils.combineTypes(Arrays.asList(evaluaedTypes));
    }

    public static ModuleDeclaration parseSource(ISourceModule module) {
        return RubySourceElementParser.parseModule(module);
    }

    public static IEvaluatedType getAmbiguousMetaType(IEvaluatedType receiver) {
        if (receiver instanceof AmbiguousType) {
            HashSet<IEvaluatedType> possibleReturns = new HashSet<IEvaluatedType>();
            AmbiguousType ambiguousType = (AmbiguousType)receiver;
            IEvaluatedType[] possibleTypes = ambiguousType.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IEvaluatedType type = possibleTypes[i];
                IEvaluatedType possibleReturn = RubyTypeInferencingUtils.getAmbiguousMetaType(type);
                possibleReturns.add(possibleReturn);
                ++i;
            }
            return RubyTypeInferencingUtils.combineTypes(possibleReturns);
        }
        return null;
    }

    public static String searchConstantElement(ModuleDeclaration module, int calculationOffset, String constantName) {
        MixinModel model = RubyMixinModel.getRawInstance();
        String[] modelStaticScopes = RubyTypeInferencingUtils.getModelStaticScopesKeys(model, module, calculationOffset);
        String resultKey = null;
        int i = modelStaticScopes.length - 1;
        while (i >= 0) {
            String possibleKey = String.valueOf(modelStaticScopes[i]) + "{" + constantName;
            if (model.keyExists(possibleKey)) {
                resultKey = possibleKey;
                break;
            }
            --i;
        }
        if (resultKey == null && model.keyExists(constantName)) {
            resultKey = constantName;
        }
        return resultKey;
    }

    public static LocalVariableInfo searchLocalVars(ModuleDeclaration module, int offset, String name) {
        ASTNode[] scopes = RubyTypeInferencingUtils.getAllStaticScopes(module, offset);
        int i = -1;
        i = scopes.length - 1;
        block2: while (i >= 0) {
            ASTNode vnode;
            Iterator iterator;
            Set vars;
            if (scopes[i] instanceof MethodDeclaration || scopes[i] instanceof TypeDeclaration) break;
            if (scopes[i] instanceof RubyBlock) {
                RubyBlock rubyBlock = (RubyBlock)scopes[i];
                vars = rubyBlock.getVars();
                iterator = vars.iterator();
                while (iterator.hasNext()) {
                    RubyDAssgnExpression v;
                    vnode = (ASTNode)iterator.next();
                    if (vnode instanceof RubyDAssgnExpression && (v = (RubyDAssgnExpression)vnode).getName().equals(name)) break block2;
                }
            } else if (scopes[i] instanceof RubyForStatement2) {
                RubyForStatement2 forst = (RubyForStatement2)scopes[i];
                vars = forst.getList();
                iterator = vars.getChilds().iterator();
                while (iterator.hasNext()) {
                    VariableReference ref;
                    RubyAssignment assign;
                    vnode = (ASTNode)iterator.next();
                    if (vnode instanceof RubyAssignment && (assign = (RubyAssignment)vnode).getLeft() instanceof VariableReference && (ref = (VariableReference)assign.getLeft()).getName().equals(name)) break block2;
                }
            }
            --i;
        }
        if (i < 0) {
            i = 0;
        }
        LocalVarSearchVisitor visitor = new LocalVarSearchVisitor(name, scopes[i], offset);
        try {
            scopes[i].traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List conds = visitor.getConditionalAssignments();
        RubyAssignment[] c = conds.toArray(new RubyAssignment[conds.size()]);
        return new LocalVariableInfo(scopes[i], c, visitor.getLast());
    }

    private static class LocalVarSearchVisitor
    extends ASTVisitor {
        private Stack conditionalStack = new Stack();
        private List conds = new ArrayList();
        private RubyAssignment last = null;
        private final String name;
        private final int offset;
        private final ASTNode root;

        public LocalVarSearchVisitor(String name, ASTNode root, int offset) {
            this.name = name;
            this.root = root;
            this.offset = offset;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node == this.root) {
                return true;
            }
            if (node instanceof MethodDeclaration || node instanceof TypeDeclaration) {
                return false;
            }
            if (node instanceof RubyAssignment) {
                VariableReference varRef;
                if (node.sourceEnd() > this.offset) {
                    return false;
                }
                RubyAssignment rubyAssignment = (RubyAssignment)node;
                ASTNode lhs = rubyAssignment.getLeft();
                if (lhs instanceof VariableReference && this.name.equals((varRef = (VariableReference)lhs).getName())) {
                    if (this.conditionalStack.size() > 0) {
                        this.conds.add(node);
                    } else {
                        this.conds.clear();
                        this.last = (RubyAssignment)node;
                    }
                }
            } else if (node instanceof RubyIfStatement || node instanceof RubyForStatement2 || node instanceof RubyWhileStatement || node instanceof RubyBlock || node instanceof RubyUntilStatement || node instanceof RubyUnlessStatement) {
                this.conditionalStack.add(node);
            }
            return true;
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            Object peek;
            if (this.conditionalStack.size() > 0 && (peek = this.conditionalStack.peek()) == node) {
                this.conditionalStack.pop();
            }
        }

        public List getConditionalAssignments() {
            return this.conds;
        }

        public RubyAssignment getLast() {
            return this.last;
        }
    }
}

