/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Document;

public class DbgpRawPacket {
    private final int size;
    private final String xml;

    protected static int readPacketSize(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        int b = -1;
        while (true) {
            if ((b = input.read()) == -1) {
                throw new IOException();
            }
            if (b == 0) break;
            sb.append((char)b);
        }
        return Integer.parseInt(sb.toString());
    }

    protected static String readPacketXml(InputStream input, int size) throws IOException {
        byte[] bytes = new byte[size];
        int offset = 0;
        int n = -1;
        while ((n = input.read(bytes, offset, size - offset)) != -1 && offset < size) {
            offset += n;
        }
        if (offset != size) {
            throw new IOException("Can't read packet body");
        }
        if (input.read() != 0) {
            throw new IOException("No termination '0' byte");
        }
        return new String(bytes, "ASCII");
    }

    public static DbgpRawPacket readPacket(InputStream input) throws IOException {
        int size = DbgpRawPacket.readPacketSize(input);
        String xml = DbgpRawPacket.readPacketXml(input, size);
        return new DbgpRawPacket(size, xml);
    }

    protected DbgpRawPacket(int size, String xml) {
        this.size = size;
        this.xml = xml;
    }

    public int getSize() {
        return this.size;
    }

    public String getXml() {
        return this.xml;
    }

    public Document getParsedXml() throws DbgpException {
        return DbgpXmlParser.parseXml(this.xml);
    }

    public String toString() {
        return "DbgpPacket (" + this.size + " bytes) " + this.xml;
    }
}

