/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.util.ArrayList;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.commands.IDbgpStatckCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.DbgpStackLevel;
import org.eclipse.dltk.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpStackCommands
extends DbgpBaseCommands
implements IDbgpStatckCommands {
    private static final String STACK_DEPTH_COMMAND = "stack_depth";
    private static final String STACK_GET_COMMAND = "stack_get";
    private static final String TAG_STACK = "stack";
    private static final String ATTR_DEPTH = "depth";

    protected int parseStackDepthResponse(Element response) throws DbgpDebuggingEngineException {
        return Integer.parseInt(response.getAttribute(ATTR_DEPTH));
    }

    protected IDbgpStackLevel[] parseStackLevels(Element response) throws DbgpException {
        ArrayList<DbgpStackLevel> list = new ArrayList<DbgpStackLevel>();
        NodeList nodes = response.getElementsByTagName(TAG_STACK);
        int i = 0;
        while (i < nodes.getLength()) {
            list.add(DbgpXmlEntityParser.parseStackLevel((Element)nodes.item(i)));
            ++i;
        }
        return list.toArray(new IDbgpStackLevel[list.size()]);
    }

    public DbgpStackCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    public int getStackDepth() throws DbgpException {
        return this.parseStackDepthResponse(this.communicate(this.createRequest(STACK_DEPTH_COMMAND)));
    }

    public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
        DbgpRequest request = this.createRequest(STACK_GET_COMMAND);
        request.addOption("-d", stackDepth);
        IDbgpStackLevel[] levels = this.parseStackLevels(this.communicate(request));
        if (levels.length < 1) {
            return null;
        }
        return levels[0];
    }

    public IDbgpStackLevel[] getStackLevels() throws DbgpException {
        return this.parseStackLevels(this.communicate(this.createRequest(STACK_GET_COMMAND)));
    }
}

