/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Util;

class AddExternalFolderToIndex
extends IndexRequest {
    IProject project;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    private static String EXISTS = "OK";
    private static String DELETED = "DELETED";

    public AddExternalFolderToIndex(IPath folderPath, IProject project, char[][] inclusionPatterns, char[][] exclusionPatterns, IndexManager manager) {
        super(folderPath, manager);
        this.project = project;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o instanceof AddExternalFolderToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddExternalFolderToIndex)o).containerPath);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        ReadWriteMonitor monitor;
        block24: {
            block23: {
                if (this.isCancelled) return true;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                if (!this.project.isAccessible()) {
                    return true;
                }
                File folder = new File(this.containerPath.toOSString());
                if (folder == null) return true;
                if (folder.isFile()) {
                    return true;
                }
                Index index = this.manager.getIndex(this.containerPath, true, false);
                if (index != null) {
                    if (!JobManager.VERBOSE) return true;
                    Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                    return true;
                }
                index = this.manager.getIndexForUpdate(this.containerPath, true, true);
                if (index == null) {
                    if (!JobManager.VERBOSE) return true;
                    Util.verbose("-> index could not be created for " + this.containerPath);
                    return true;
                }
                monitor = index.monitor;
                if (monitor == null) {
                    if (!JobManager.VERBOSE) return true;
                    Util.verbose("-> index for " + this.containerPath + " just got deleted");
                    return true;
                }
                try {
                    try {
                        monitor.enterRead();
                        IPath container = this.containerPath;
                        IndexManager indexManager = this.manager;
                        IScriptProject project = DLTKCore.create(this.project);
                        ISourceElementParser parser = indexManager.getSourceElementParser(project, null);
                        SourceIndexerRequestor requestor = indexManager.getSourceRequestor(project);
                        if (JobManager.VERBOSE) {
                            Util.verbose("-> indexing " + this.containerPath.toOSString());
                        }
                        long initialTime = System.currentTimeMillis();
                        String[] paths = index.queryDocumentNames("");
                        if (paths != null) {
                            boolean needToReindex;
                            int max = paths.length;
                            SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                            int i = 0;
                            while (true) {
                                if (i >= max) {
                                    this.visit(indexedFileNames, project, folder, parser, requestor, indexManager, container, false, null, index);
                                    boolean bl = needToReindex = indexedFileNames.elementSize != max;
                                }
                                indexedFileNames.put(paths[i], DELETED);
                                ++i;
                            }
                            if (!needToReindex) {
                                Object[] valueTable = indexedFileNames.valueTable;
                                int i2 = 0;
                                int l = valueTable.length;
                                while (i2 < l) {
                                    if (valueTable[i2] == DELETED) {
                                        needToReindex = true;
                                        break;
                                    }
                                    ++i2;
                                }
                                if (!needToReindex) {
                                    if (JobManager.VERBOSE) {
                                        Util.verbose("-> no indexing required (index is consistent with library) for " + this.containerPath.toOSString() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                    }
                                    this.manager.saveIndex(index);
                                    Object var19_20 = null;
                                    monitor.exitRead();
                                    return true;
                                }
                            }
                        }
                        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                        index = this.manager.recreateIndex(this.containerPath);
                        if (index == null) {
                            this.manager.removeIndex(this.containerPath);
                            break block23;
                        }
                        this.visit(null, project, folder, parser, requestor, indexManager, container, true, participant, index);
                        this.manager.saveIndex(index);
                        if (JobManager.VERBOSE) {
                            Util.verbose("-> done indexing of " + this.containerPath.toOSString() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                        }
                        break block24;
                    }
                    catch (IOException ex) {
                        if (JobManager.VERBOSE) {
                            Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                            ex.printStackTrace();
                        }
                        this.manager.removeIndex(this.containerPath);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            Object var19_21 = null;
            monitor.exitRead();
            return false;
        }
        Object var19_23 = null;
        monitor.exitRead();
        return true;
    }

    private void visit(SimpleLookupTable table, IScriptProject project, File folder, ISourceElementParser parser, SourceIndexerRequestor requestor, IndexManager indexManager, IPath container, boolean operation, SearchParticipant participant, Index index) {
        IDLTKLanguageToolkit toolkit;
        block18: {
            toolkit = null;
            try {
                toolkit = DLTKLanguageManager.getLanguageToolkit(project);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block18;
                e.printStackTrace();
            }
        }
        File[] files = folder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (this.isCancelled) {
                    if (JobManager.VERBOSE) {
                        Util.verbose("-> indexing of " + this.containerPath.toOSString() + " has been cancelled");
                    }
                    return;
                }
                if (files[i].isDirectory()) {
                    Path fPath = new Path(files[i].getAbsolutePath());
                    boolean valid = Util.isValidSourcePackageName(project, (IPath)fPath);
                    if (fPath.segmentCount() == 0 || valid) {
                        this.visit(table, project, files[i], parser, requestor, indexManager, container, operation, participant, index);
                    }
                } else {
                    String path = files[i].getAbsolutePath();
                    Path rPath = new Path(path);
                    if (Util.isValidSourceModuleName(project, path)) {
                        if (DLTKCore.DEBUG) {
                            System.err.println("Out:" + path);
                        }
                        if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                            if (!operation) {
                                table.put(rPath.toString(), EXISTS);
                            } else {
                                this.indexDocument(parser, requestor, participant, index, path, toolkit);
                            }
                        } else if (!Util.isExcluded((IPath)rPath, this.inclusionPatterns, this.exclusionPatterns, false)) {
                            if (!operation) {
                                table.put(rPath.toString(), EXISTS);
                            } else {
                                this.indexDocument(parser, requestor, participant, index, path, toolkit);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void indexDocument(ISourceElementParser parser, SourceIndexerRequestor requestor, SearchParticipant participant, Index index, String path, IDLTKLanguageToolkit toolkit) {
        char[] contents = null;
        File ffile = new File(path);
        if (ffile != null && ffile.exists()) {
            try {
                contents = Util.getResourceContentsAsCharArray(ffile);
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        IPath dpath = new Path(path).removeFirstSegments(this.containerPath.segmentCount());
        dpath = dpath.setDevice(null);
        DLTKSearchDocument entryDocument = new DLTKSearchDocument(dpath.toOSString(), this.containerPath, contents, participant, true);
        entryDocument.parser = parser;
        entryDocument.requestor = requestor;
        entryDocument.toolkit = toolkit;
        this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
    }

    public String toString() {
        return "adding " + this.containerPath + " to index " + this.containerPath;
    }
}

