/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;

public class ArchiveEntryFile
extends PlatformObject
implements IStorage {
    private String entryName;
    private String zipName;
    private IPath path;

    public ArchiveEntryFile(String entryName, String zipName, IPath parentRelativePath) {
        this.entryName = entryName;
        this.zipName = zipName;
        this.path = parentRelativePath;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipFile zipFile;
            ZipEntry zipEntry;
            if (ModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
            }
            if ((zipEntry = (zipFile = new ZipFile(this.zipName)).getEntry(this.entryName)) == null) {
                throw new ModelException(new ModelStatus(979, this.entryName));
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
    }
}

