/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class MainLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    protected Text fProjText;
    private Button fProjButton;
    private WidgetListener fListener = new WidgetListener();
    protected Text fMainText;
    private Button fSearchButton;

    protected IScriptProject chooseProject() {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)this.getNatureID());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_message);
        try {
            dialog.setElements((Object[])DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getScriptProjects());
        }
        catch (ModelException jme) {
            DLTKLaunchingPlugin.log((Throwable)jme);
        }
        IScriptProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(DLTKLaunchConfigurationsMessages.mainTab_projectGroup);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton((Composite)group, DLTKLaunchConfigurationsMessages.mainTab_projectButton, null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IScriptProject getProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getScriptModel().getScriptProject(projectName);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected abstract boolean validateProject(IScriptProject var1);

    protected abstract String getLanguageName();

    protected abstract String getNatureID();

    protected void handleProjectButtonSelected() {
        IScriptProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        if (!this.validateProject(project)) {
            String msg = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_notALangProject, (Object[])new String[]{this.getLanguageName()});
            String reason = Messages.format((String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_reasonNotALangProject, (Object[])new String[]{this.getLanguageName()});
            ErrorDialog.openError((Shell)this.getShell(), (String)DLTKLaunchConfigurationsMessages.mainTab_errorDlg_invalidProject, (String)msg, (IStatus)DLTKUIStatus.createError((int)4, (String)reason, null));
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        IModelElement me;
        IScriptProject project;
        IEditorInput editorInput;
        IEditorPart editor;
        IWorkbenchPage page;
        this.updateProjectFromConfig(config);
        this.updateMainModuleFromConfig(config);
        if (this.fProjText.getText().trim().length() == 0 && this.fMainText.getText().trim().length() == 0 && (page = DLTKUIPlugin.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (editorInput = editor.getEditorInput()) != null && (project = (me = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editorInput)).getScriptProject()) != null && this.validateProject(project)) {
            String projectName = project.getProject().getName();
            String scriptName = me.getResource().getProjectRelativePath().toPortableString();
            if (scriptName.trim().length() > 0) {
                this.fProjText.setText(projectName);
                this.fMainText.setText(scriptName);
            }
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute("project", EMPTY_STRING);
        }
        catch (CoreException ce) {
            DLTKLaunchingPlugin.log((Throwable)ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void createMainModuleEditor(Composite parent, String text) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(text);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fMainText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton((Composite)mainGroup, DLTKLaunchConfigurationsMessages.mainTab_searchButton, null);
        this.fSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MainLaunchConfigurationTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_searchButton_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_searchButton_message);
        IScriptProject proj = this.getProject();
        if (proj == null) {
            return;
        }
        dialog.setInput((Object)proj.getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getProjectRelativePath().toPortableString();
            this.fMainText.setText(arg);
        }
    }

    protected void updateMainModuleFromConfig(ILaunchConfiguration config) {
        String mainModuleName = EMPTY_STRING;
        try {
            mainModuleName = config.getAttribute("mainScript", EMPTY_STRING);
        }
        catch (CoreException ce) {
            DLTKLaunchingPlugin.log((Throwable)ce);
        }
        this.fMainText.setText(mainModuleName);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainModuleEditor(comp, DLTKLaunchConfigurationsMessages.mainTab_mainModule);
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.mainTab_title;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String mainModule = this.fMainText.getText().trim();
        String project = this.fProjText.getText().trim();
        configuration.setAttribute("mainScript", mainModule);
        configuration.setAttribute("project", project);
    }

    protected boolean validateProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectProject);
            return false;
        }
        IScriptProject proj = this.getScriptModel().getScriptProject(projectName);
        if (proj == null || !this.validateProject(proj)) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
            return false;
        }
        return true;
    }

    protected boolean validateModule() {
        String mainModule = this.fMainText.getText().trim();
        if (mainModule.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectScript);
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return this.validateProject() && this.validateModule();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateProject() && this.validateModule();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            MainLaunchConfigurationTab.this.setErrorMessage(null);
            if (e.getSource() == MainLaunchConfigurationTab.this.fProjText) {
                IScriptProject proj = MainLaunchConfigurationTab.this.getProject();
                if (proj != null) {
                    if (!MainLaunchConfigurationTab.this.validateProject(proj)) {
                        MainLaunchConfigurationTab.this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_notAValidProject);
                    }
                } else {
                    MainLaunchConfigurationTab.this.setErrorMessage(DLTKLaunchConfigurationsMessages.error_selectProject);
                }
            }
            MainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == MainLaunchConfigurationTab.this.fProjButton) {
                MainLaunchConfigurationTab.this.handleProjectButtonSelected();
            } else {
                MainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

