/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.declarations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.Decorator;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.internal.compiler.lookup.MethodScope;
import org.eclipse.dltk.utils.CorePrinter;

public class MethodDeclaration
extends Declaration {
    public MethodScope scope;
    protected int bodyStart = -1;
    protected int bodyEnd = -1;
    protected List arguments = new ArrayList();
    private Block body = new Block();
    private List decorators;
    private String declaringTypeName;

    public MethodDeclaration(DLTKToken function_t, DLTKToken name) {
        super(name, function_t.getColumn(), name.getColumn() + name.getText().length());
    }

    public MethodDeclaration(String name, int nameStart, int nameEnd, int declStart, int declEnd) {
        super(declStart, declEnd);
        this.setName(name);
        this.setNameStart(nameStart);
        this.setNameEnd(nameEnd);
    }

    public MethodDeclaration(int start, int end) {
        super(start, end);
    }

    public void setDecorators(List decorators) {
        this.decorators = decorators;
    }

    public List getDecorators() {
        return this.decorators;
    }

    public int getKind() {
        return 3002;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            Iterator it;
            if (this.decorators != null) {
                it = this.decorators.iterator();
                while (it.hasNext()) {
                    Decorator dec = (Decorator)it.next();
                    dec.traverse(visitor);
                }
            }
            it = this.arguments.iterator();
            while (it.hasNext()) {
                Argument arg = (Argument)it.next();
                arg.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    public List getArguments() {
        return this.arguments;
    }

    public void addArgument(Argument arg) {
        this.arguments.add(arg);
    }

    public void acceptArguments(List arguments) {
        this.arguments = arguments;
    }

    public void acceptBody(Block block) {
        this.acceptBody(block, true);
    }

    public void setBody(ASTListNode statement) {
        Block b = new Block(statement.sourceStart(), statement.sourceEnd());
        b.acceptStatements(statement.getChilds());
        this.acceptBody(b, true);
    }

    public void acceptBody(Block block, boolean replace) {
        this.body = block;
        if (block != null) {
            this.bodyStart = block.sourceStart();
            this.bodyEnd = block.sourceEnd();
            if (replace) {
                this.setEnd(block.sourceEnd());
            }
        }
    }

    public List getStatements() {
        if (this.body == null) {
            this.body = new Block(this.sourceStart(), this.sourceEnd());
        }
        return this.body.getStatements();
    }

    public Block getBody() {
        return this.body;
    }

    public void printNode(CorePrinter output) {
        if (this.decorators != null) {
            Iterator i = this.decorators.iterator();
            while (i.hasNext()) {
                ((Decorator)i.next()).printNode(output);
            }
        }
        output.formatPrintLn("Method" + this.getSourceRange().toString() + this.getNameSourceRange().toString() + ": " + super.toString());
        output.formatPrintLn("(");
        if (this.arguments != null && this.arguments.size() > 0) {
            boolean first = true;
            Iterator i = this.arguments.iterator();
            while (i.hasNext()) {
                Argument argument = (Argument)i.next();
                if (!first) {
                    output.formatPrintLn(", ");
                } else {
                    first = false;
                }
                argument.printNode(output);
            }
        }
        output.formatPrintLn(")");
        if (this.body != null) {
            this.body.printNode(output);
        }
    }

    public void setDeclaringTypeName(String name) {
        if (name != null && name.length() > 0) {
            this.declaringTypeName = name;
        }
    }

    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration d = (MethodDeclaration)obj;
        if (this.declaringTypeName == null && d.declaringTypeName != null || this.declaringTypeName != null && d.declaringTypeName == null) {
            return false;
        }
        return d.name.equals(this.name) && d.nameStart == this.nameStart && d.nameEnd == this.nameEnd && (this.declaringTypeName == null || this.declaringTypeName.equals(d.declaringTypeName));
    }
}

