/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.codeassist.InternalCompletionProposal;

public final class CompletionProposal
extends InternalCompletionProposal {
    public static final int FIELD_REF = 1;
    public static final int KEYWORD = 2;
    public static final int LABEL_REF = 3;
    public static final int LOCAL_VARIABLE_REF = 4;
    public static final int METHOD_REF = 5;
    public static final int METHOD_DECLARATION = 6;
    public static final int TYPE_REF = 7;
    public static final int VARIABLE_DECLARATION = 8;
    public static final int POTENTIAL_METHOD_DECLARATION = 9;
    public static final int METHOD_NAME_REFERENCE = 10;
    public static final int ANNOTATION_ATTRIBUTE_REF = 11;
    public static final int DOC_FIELD_REF = 12;
    public static final int DOC_METHOD_REF = 13;
    public static final int DOC_TYPE_REF = 14;
    public static final int DOC_VALUE_REF = 15;
    public static final int DOC_PARAM_REF = 16;
    public static final int DOC_BLOCK_TAG = 17;
    public static final int DOC_INLINE_TAG = 18;
    public static final int PACKAGE_REF = 22;
    protected static final int FIRST_KIND = 1;
    protected static final int LAST_KIND = 22;
    private boolean updateCompletion = false;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private char[] completion = CharOperation.NO_CHAR;
    public Object extraInfo;
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private char[] declarationKey = null;
    private char[] name = null;
    private char[] key = null;
    private int flags = 0;
    private char[][] parameterNames = null;
    private IModelElement modelElement;

    public static CompletionProposal create(int kind, int completionOffset) {
        return new CompletionProposal(kind, completionOffset);
    }

    protected CompletionProposal(int kind, int completionLocation) {
        if (kind < 1 || kind > 22) {
            throw new IllegalArgumentException();
        }
        if (this.completion == null || completionLocation < 0) {
            if (this.completion == null || completionLocation != -1) {
                throw new IllegalArgumentException();
            }
            completionLocation = 0;
        }
        this.completionKind = kind;
        this.completionLocation = completionLocation;
    }

    public int getKind() {
        return this.completionKind;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.tokenStart = startIndex;
        this.tokenEnd = endIndex;
    }

    public char[] getCompletion() {
        if (this.completionKind == 6) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length);
                    int start = 0;
                    int end = CharOperation.indexOf('%', this.completion);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = CharOperation.indexOf('%', this.completion, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length - start);
                        }
                        ++i;
                    }
                    int nameLength = completionBuffer.length();
                    this.completion = new char[nameLength];
                    completionBuffer.getChars(0, nameLength, this.completion, 0);
                }
            }
        }
        return this.completion;
    }

    public void setCompletion(char[] completion) {
        this.completion = completion;
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int rating) {
        if (rating <= 0) {
            throw new IllegalArgumentException();
        }
        this.relevance = rating;
    }

    public char[] getDeclarationKey() {
        return this.declarationKey;
    }

    public void setDeclarationKey(char[] key) {
        this.declarationKey = key;
    }

    public char[] getName() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    public char[] getKey() {
        return this.key;
    }

    public void setKey(char[] key) {
        this.key = key;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public char[][] findParameterNames(IProgressMonitor monitor) {
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        switch (this.completionKind) {
            case 1: {
                buffer.append("FIELD_REF");
                break;
            }
            case 2: {
                buffer.append("KEYWORD");
                break;
            }
            case 3: {
                buffer.append("LABEL_REF");
                break;
            }
            case 4: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 6: {
                buffer.append("METHOD_DECLARATION");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 5: {
                buffer.append("METHOD_REF");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 7: {
                buffer.append("TYPE_REF");
                break;
            }
            case 8: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 9: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 10: {
                buffer.append("METHOD_IMPORT");
                break;
            }
            case 11: {
                buffer.append("ANNOTATION_ATTRIBUTE_REF");
                break;
            }
            case 17: {
                buffer.append("JAVADOC_BLOCK_TAG");
                break;
            }
            case 18: {
                buffer.append("JAVADOC_INLINE_TAG");
                break;
            }
            case 12: {
                buffer.append("JAVADOC_FIELD_REF");
                break;
            }
            case 13: {
                buffer.append("JAVADOC_METHOD_REF");
                break;
            }
            case 14: {
                buffer.append("JAVADOC_TYPE_REF");
                break;
            }
            case 16: {
                buffer.append("JAVADOC_PARAM_REF");
                break;
            }
            case 15: {
                buffer.append("JAVADOC_VALUE_REF");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        buffer.append("]{completion:");
        if (this.completion != null) {
            buffer.append(this.completion);
        }
        buffer.append(", declSign:");
        buffer.append(", declKey:");
        if (this.declarationKey != null) {
            buffer.append(this.declarationKey);
        }
        buffer.append(", key:");
        if (this.key != null) {
            buffer.append(this.key);
        }
        buffer.append(", name:");
        if (this.name != null) {
            buffer.append(this.name);
        }
        buffer.append(", [");
        buffer.append(this.replaceStart);
        buffer.append(',');
        buffer.append(this.replaceEnd);
        buffer.append("], relevance=");
        buffer.append(this.relevance);
        buffer.append('}');
        return buffer.toString();
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public void setModelElement(IModelElement modelElement) {
        this.modelElement = modelElement;
    }
}

