/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuiltinScriptFolderInfo;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;

public class BuiltinScriptFolder
extends ScriptFolder {
    public BuiltinScriptFolder(ProjectFragment parent, IPath path) {
        super(parent, path);
    }

    void computeForeignResources(BuiltinScriptFolderInfo info) {
        info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
    }

    public ISourceModule getSourceModule(String name) {
        return new BuiltinSourceModule(this, name, DefaultWorkingCopyOwner.PRIMARY);
    }

    protected boolean computeChildren(OpenableElementInfo info, String[] entryNames) {
        if (entryNames != null && entryNames.length > 0) {
            ArrayList<ISourceModule> vChildren = new ArrayList<ISourceModule>();
            int iter = 0;
            while (iter < entryNames.length) {
                String child = entryNames[iter];
                ISourceModule classFile = this.getSourceModule(child);
                vChildren.add(classFile);
                ++iter;
            }
            IModelElement[] children = new IModelElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected Object createElementInfo() {
        return null;
    }

    protected boolean resourceExists() {
        return true;
    }

    public Object[] getForeignResources() throws ModelException {
        return ((BuiltinScriptFolderInfo)this.getElementInfo()).getForeignResources();
    }
}

