/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public abstract class ModelElement
extends PlatformObject
implements IModelElement {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_SCRIPTPROJECT = '=';
    public static final char JEM_PROJECTFRAGMENT = '/';
    public static final char JEM_SCRIPTFOLDER = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_SOURCEMODULE = '{';
    public static final char JEM_TYPE = '[';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final char JEM_TYPE_PARAMETER = ']';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_SKIP_DELIMETER = '>';
    protected ModelElement parent;
    protected static final ModelElement[] NO_ELEMENTS = new ModelElement[0];
    protected static final Object NO_INFO = new Object();

    protected ModelElement(ModelElement parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public IModelElement getAncestor(int ancestorType) {
        IModelElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public void close() throws ModelException {
        ModelManager.getModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws ModelException;

    public Object getElementInfo() throws ModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    /*
     * Exception decompiling
     */
    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws ModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 104->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public IModelElement getParent() {
        return this.parent;
    }

    protected abstract Object createElementInfo();

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws ModelException;

    public String getElementName() {
        return "";
    }

    public ModelException newNotPresentException() {
        return new ModelException(new ModelStatus(969, this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        ModelElement other = (ModelElement)o;
        return this.getElementName().equals(other.getElementName()) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IModelElement e) {
        IModelElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected ArrayList getChildrenOfType(int type) throws ModelException {
        IModelElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<ModelElement> list = new ArrayList<ModelElement>(size);
        int i = 0;
        while (i < size) {
            ModelElement elt = (ModelElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IModelElement[] getChildren() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof ModelElementInfo) {
            return ((ModelElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public IScriptModel getModel() {
        IModelElement current = this;
        do {
            if (!(current instanceof IScriptModel)) continue;
            return (IScriptModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ModelException newModelException(IStatus status) {
        if (status instanceof IModelStatus) {
            return new ModelException((IModelStatus)status);
        }
        return new ModelException(new ModelStatus(status.getSeverity(), status.getCode(), status.getMessage()));
    }

    public IScriptProject getScriptProject() {
        IModelElement current = this;
        do {
            if (!(current instanceof IScriptProject)) continue;
            return (IScriptProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public boolean hasChildren() throws ModelException {
        Object elementInfo = ModelManager.getModelManager().getInfo(this);
        if (elementInfo instanceof ModelElementInfo) {
            return ((ModelElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, true);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        ModelElement parentElement = (ModelElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO, false);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof ModelElementInfo)) {
            return;
        }
        IModelElement[] children = ((ModelElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((ModelElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = ModelManager.getModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info, true);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
    }

    protected IModelElement getSourceElementAt(int position) throws ModelException {
        IModelElement res = this.getSourceElementAtTop(position);
        if (res != this) {
            return res;
        }
        if (this instanceof ISourceReference) {
            IModelElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                SourceRefElement child;
                IModelElement aChild = children[i];
                if (aChild instanceof SourceRefElement && (child = (SourceRefElement)children[i]) instanceof IParent && (res = child.getSourceElementAt(position)) != child) {
                    return res;
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    protected IModelElement getSourceElementAtTop(int position) throws ModelException {
        if (this instanceof ISourceReference) {
            IModelElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IModelElement aChild = children[i];
                if (aChild instanceof SourceRefElement) {
                    SourceRefElement child = (SourceRefElement)children[i];
                    ISourceRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IField) {
                            int declarationStart = start;
                            SourceRefElement candidate = null;
                            do {
                                if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                                    return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                                }
                                candidate = child;
                                SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                            } while (child != null && child.getSourceRange().getOffset() == declarationStart);
                            return candidate.getSourceElementAt(position);
                        }
                        if (child instanceof IParent) {
                            return child.getSourceElementAt(position);
                        }
                        return child;
                    }
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    public abstract void printNode(CorePrinter var1);

    public IModelElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    public IModelElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public abstract IModelElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public ISourceModule getSourceModule() {
        return null;
    }

    public void accept(IModelElementVisitor visitor) throws ModelException {
        if (visitor.visit(this)) {
            IModelElement[] elements = this.getChildren();
            int i = 0;
            while (i < elements.length) {
                elements[i].accept(visitor);
                ++i;
            }
        }
    }
}

