/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;

public class ScriptValue
extends ScriptDebugElement
implements IScriptValue {
    private final IScriptVariable variable;

    protected ScriptValue(IScriptVariable variable) {
        this.variable = variable;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getType().getName();
    }

    public String getValueString() throws DebugException {
        IScriptType type;
        String value = this.variable.getValueString();
        if (!(value != null && value.length() != 0 || (type = this.getType()).isAtomic())) {
            StringBuffer sb = new StringBuffer();
            sb.append(type.getName());
            String id = this.getInstanceId();
            if (id != null) {
                sb.append(" (id = " + id + ")");
            }
            return sb.toString();
        }
        return value;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variable.getChildren();
    }

    public boolean hasVariables() throws DebugException {
        return this.variable.hasChildren();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String toString() {
        return this.variable.getValueString();
    }

    public IDebugTarget getDebugTarget() {
        return this.variable.getDebugTarget();
    }

    public String getInstanceId() {
        return this.variable.getId();
    }

    public IScriptType getType() {
        return this.variable.getType();
    }

    public String getEvalName() {
        return this.variable.getEvalName();
    }
}

