/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class ClassInstanceType
implements IClassType {
    private TypeDeclaration fClass;
    private ModuleDeclaration fModule;

    public ClassInstanceType(ModuleDeclaration module, TypeDeclaration method) {
        this.fClass = method;
        this.fModule = module;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassInstanceType) {
            ClassInstanceType m = (ClassInstanceType)obj;
            if (this.fClass == m.fClass && this.fModule == m.fModule) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fClass.hashCode() * 10 + this.fModule.hashCode();
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.fClass;
    }

    public String getTypeName() {
        if (this.fClass != null) {
            return "class:" + this.fClass.getName() + " instance";
        }
        return "class instance: !!unknown!!";
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }
}

