/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.ui.RubyLabelProvider;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;

public class RubyCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    private static final String SEPARATOR = " - ";
    private static final String PACKAGE_SEPARATOR = "::";

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        IMethod method = (IMethod)methodProposal.getModelElement();
        nameBuffer.append(SEPARATOR);
        if (method instanceof FakeMethod && ((FakeMethod)method).getReceiver() != null) {
            nameBuffer.append(((FakeMethod)method).getReceiver());
        } else {
            IModelElement parent = method.getParent();
            if (parent instanceof IType) {
                IType type = (IType)parent;
                nameBuffer.append(type.getTypeQualifiedName(PACKAGE_SEPARATOR));
            } else {
                nameBuffer.append(parent.getElementName());
            }
        }
        return nameBuffer.toString();
    }

    protected String createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        IMethod method = (IMethod)methodProposal.getModelElement();
        nameBuffer.append(SEPARATOR);
        if (method instanceof FakeMethod && ((FakeMethod)method).getReceiver() != null) {
            String receiver = ((FakeMethod)method).getReceiver();
            nameBuffer.append(receiver);
        } else {
            IModelElement parent = method.getParent();
            if (parent instanceof IType) {
                IType type = (IType)parent;
                nameBuffer.append(type.getTypeQualifiedName(PACKAGE_SEPARATOR));
            } else {
                nameBuffer.append(parent.getElementName());
            }
        }
        return nameBuffer.toString();
    }

    protected String createTypeProposalLabel(CompletionProposal typeProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        IType type = (IType)typeProposal.getModelElement();
        RubyLabelProvider.appendQualifiedType(type, nameBuffer);
        return nameBuffer.toString();
    }
}

