/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.ui.viewsupport.AbstractModelElementFilter;
import org.eclipse.dltk.ui.viewsupport.MemberFilterAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class MemberFilterActionGroup
extends ActionGroup {
    IPreferenceStore fStore;
    private MemberFilterAction[] fFilterActions;
    private StructuredViewer fViewer;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer viewer, IPreferenceStore store) {
        this(viewer, store, false);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, IPreferenceStore store, boolean inViewMenu) {
        this.fViewer = viewer;
        this.fStore = store;
        this.fInViewMenu = inViewMenu;
    }

    public void setActions(MemberFilterAction[] actions) {
        this.fFilterActions = new MemberFilterAction[actions.length];
        int i = 0;
        while (i < actions.length) {
            MemberFilterAction action = actions[i];
            AbstractModelElementFilter filter = action.getFilter();
            boolean filterEnabled = false;
            if (this.fStore != null) {
                filterEnabled = this.fStore.getBoolean(this.getPreferenceKey(action.getFilter().getFilteringType()));
            }
            if (filterEnabled) {
                this.fViewer.addFilter((ViewerFilter)filter);
            } else {
                this.fViewer.removeFilter((ViewerFilter)filter);
            }
            action.setChecked(filterEnabled);
            this.fFilterActions[i] = action;
            ++i;
        }
    }

    private String getPreferenceKey(String filterProperty) {
        return "MemberFilterActionGroup." + filterProperty;
    }

    public void processMemberFilterAction(MemberFilterAction action) {
        boolean set = action.isChecked();
        AbstractModelElementFilter filter = action.getFilter();
        if (this.fStore != null) {
            this.fStore.setValue(this.getPreferenceKey(filter.getFilteringType()), set);
        }
        if (set) {
            this.fViewer.addFilter((ViewerFilter)filter);
        } else {
            this.fViewer.removeFilter((ViewerFilter)filter);
        }
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                MemberFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        if (this.fInViewMenu || this.fFilterActions == null) {
            return;
        }
        int i = 0;
        while (i < this.fFilterActions.length) {
            tbm.add((IAction)this.fFilterActions[i]);
            ++i;
        }
    }

    public void contributeToViewMenu(IMenuManager menu) {
        if (!this.fInViewMenu) {
            return;
        }
        if (menu.find("filters") != null) {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.prependToGroup("filters", (IAction)this.fFilterActions[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.add((IAction)this.fFilterActions[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }
}

