/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.utils.TextUtils;

public class SourceLineTrackerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SourceLineTrackerTests.class);
    }

    public void testNotTerminatedSingleLine() {
        String input = "1234567890";
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)input);
        SourceLineTrackerTests.assertEquals((int)1, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertNull((Object)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLineLength(0));
    }

    public void testTerminatedSingleLine() {
        String input = "1234567890\r\n";
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)input);
        SourceLineTrackerTests.assertEquals((int)1, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertEquals((String)"\r\n", (String)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLineLength(0));
    }

    public void testTwoLines() {
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)"1234567890\r\n1234567890");
        SourceLineTrackerTests.assertEquals((int)2, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n1234567890".length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertEquals((String)"\r\n", (String)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertNull((Object)tracker.getLineDelimiter(1));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n".length(), (int)tracker.getLineOffset(1));
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n".length(), (int)tracker.getLineLength(0));
        SourceLineTrackerTests.assertEquals((int)"1234567890".length(), (int)tracker.getLineLength(1));
    }

    public void testLineOffsetLastLineNoLineDelimiter() {
        ISourceLineTracker lineTracker = TextUtils.createLineTracker((String)"123\n456");
        SourceLineTrackerTests.assertEquals((int)2, (int)lineTracker.getNumberOfLines());
        SourceLineTrackerTests.assertNotNull((Object)lineTracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertNull((Object)lineTracker.getLineDelimiter(1));
        SourceLineTrackerTests.assertEquals((int)0, (int)lineTracker.getLineOffset(2));
    }

    public void testLineOffsetLastLineWithLineDelimiter() {
        ISourceLineTracker lineTracker = TextUtils.createLineTracker((String)"123\n456\n");
        SourceLineTrackerTests.assertEquals((int)2, (int)lineTracker.getNumberOfLines());
        SourceLineTrackerTests.assertNotNull((Object)lineTracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertNotNull((Object)lineTracker.getLineDelimiter(1));
        SourceLineTrackerTests.assertEquals((int)lineTracker.getLength(), (int)lineTracker.getLineOffset(2));
    }
}

