/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUtil {
    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr != null) {
                if (curr.matches(4)) {
                    return curr;
                }
                if (max == null || curr.getSeverity() > max.getSeverity()) {
                    max = curr;
                }
            }
            ++i;
        }
        return max;
    }

    public static boolean isError(List<IStatus> statuses) {
        for (IStatus curr : statuses) {
            if (!curr.matches(4)) continue;
            return true;
        }
        return false;
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

