/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 
 *******************************************************************************/
package org.eclipse.dltk.codeassist;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IScriptProject;

public interface ICompletionEngine {
	void complete(IModuleSource module, int position, int i);

	void setRequestor(CompletionRequestor requestor);

	void setOptions(Map options);

	void setProject(IScriptProject project);

	/**
	 * @since 2.0
	 */
	void setProgressMonitor(IProgressMonitor progressMonitor);
}
