# This file tests the AssocData facility of Tcl
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: assocd.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

if {[string compare testsetassocdata [info commands testsetassocdata]] != 0} {
    puts "This application hasn't been compiled with the tests for assocData,"
    puts "therefore I am skipping all of these tests."
    ::tcltest::cleanupTests
    return
}

test assocd-1.1 {testing setting assoc data} {
   testsetassocdata a 1
} ""
test assocd-1.2 {testing setting assoc data} {
   testsetassocdata a 2
} ""
test assocd-1.3 {testing setting assoc data} {
   testsetassocdata 123 456
} ""
test assocd-1.4 {testing setting assoc data} {
   testsetassocdata abc "abc d e f"
} ""

test assocd-2.1 {testing getting assoc data} {
   testgetassocdata a
} 2
test assocd-2.2 {testing getting assoc data} {
   testgetassocdata 123
} 456
test assocd-2.3 {testing getting assoc data} {
   testgetassocdata abc
} {abc d e f}
test assocd-2.4 {testing getting assoc data} {
   testgetassocdata xxx
} ""

test assocd-3.1 {testing deleting assoc data} {
   testdelassocdata a
} ""
test assocd-3.2 {testing deleting assoc data} {
   testdelassocdata 123
} ""
test assocd-3.3 {testing deleting assoc data} {
   list [catch {testdelassocdata nonexistent} msg] $msg
} {0 {}}

# cleanup
::tcltest::cleanupTests
return












