/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcesSelectionDialog
extends Dialog {
    private ListViewer sourcesViewer;
    private Set<String> sources = new HashSet<String>();
    private IEnvironmentUI environmentUI;
    private IEnvironment environment;
    private Button remove;
    private Button add;

    protected SourcesSelectionDialog(IShellProvider parentShell, IEnvironment environment) {
        super(parentShell);
        this.environment = environment;
        this.environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Files Selection Dialog");
        Composite contents = (Composite)super.createDialogArea(parent);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.sourcesViewer = new ListViewer(contents, 2052);
        this.sourcesViewer.setLabelProvider((IBaseLabelProvider)new SourcesLabelProvider());
        this.sourcesViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        this.sourcesViewer.setInput(this.sources);
        this.sourcesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(contents, 0);
        buttons.setLayoutData((Object)new GridData(-1, 4, false, true));
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.add = new Button(buttons, 8);
        this.add.setText("Add");
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String file = SourcesSelectionDialog.this.environmentUI.selectFile(SourcesSelectionDialog.this.sourcesViewer.getList().getShell(), 0);
                if (file != null) {
                    SourcesSelectionDialog.this.sources.add(file);
                    SourcesSelectionDialog.this.sourcesViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.add.setLayoutData((Object)new GridData(4, -1, true, false));
        this.remove = new Button(buttons, 8);
        this.remove.setText("Remove");
        this.remove.setLayoutData((Object)new GridData(4, -1, true, false));
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String path = SourcesSelectionDialog.this.getSelection();
                if (path != null) {
                    SourcesSelectionDialog.this.sources.remove(path);
                    SourcesSelectionDialog.this.sourcesViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateEnablement();
        this.sourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SourcesSelectionDialog.this.updateEnablement();
            }
        });
        this.getShell().layout();
        return contents;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        if (size.x < 400) {
            size.x = 400;
        }
        if (size.y < 300) {
            size.y = 300;
        }
        return size;
    }

    private String getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.sourcesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (String)selection.getFirstElement();
    }

    private void updateEnablement() {
        String path = this.getSelection();
        if (path == null) {
            this.remove.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
        }
    }

    public void setSources(Collection<String> value) {
        this.sources.clear();
        this.sources.addAll(value);
    }

    public Collection<String> getSources() {
        return Collections.unmodifiableCollection(this.sources);
    }

    private final class SourcesContentProvider
    implements IStructuredContentProvider {
        private SourcesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return SourcesSelectionDialog.this.sources.toArray();
        }
    }

    private final class SourcesLabelProvider
    extends LabelProvider {
        private SourcesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return "";
        }
    }
}

