/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.internal.core.packages.TclBuildPathPackageCollector;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclPackage;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclResolver {
    private IResolveElementParent resolver;
    private ModuleDeclaration moduleDeclaration;
    private ISourceModule sourceModule;

    public TclResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, IResolveElementParent resolver) {
        this(sourceModule, moduleDeclaration);
        this.resolver = resolver;
    }

    public TclResolver(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration) {
        this.sourceModule = sourceModule;
        this.moduleDeclaration = moduleDeclaration;
    }

    public IModelElement findModelElementFrom(ASTNode node) {
        List statements = this.moduleDeclaration.getStatements();
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        this.searchAddElementsTo(statements, node, (IParent)this.sourceModule, elements);
        if (elements.size() == 1) {
            return (IModelElement)elements.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void searchAddElementsTo(List statements, ASTNode node, IParent element, List<IModelElement> selectionElements) {
        if (statements == null || element == null) {
            return;
        }
        for (ASTNode nde : statements) {
            block26: {
                block25: {
                    if (!nde.equals(node)) break block26;
                    if (!(node instanceof MethodDeclaration) || (oName = ((MethodDeclaration)node).getName()).indexOf("::") == -1) break block25;
                    pName = oName.substring(0, oName.lastIndexOf("::"));
                    if (!(pName = pName.replaceAll("::", "\\$")).startsWith("$")) ** GOTO lbl18
                    if (pName.equals("$")) {
                        element = this.sourceModule;
                    } else {
                        try {
                            element = TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                        }
                        catch (ModelException e) {
                            if (DLTKCore.DEBUG) {
                                e.printStackTrace();
                            }
                            break block25;
                        }
lbl18:
                        // 1 sources

                        pName = "$" + pName;
                        try {
                            element = TclResolver.findTypeFrom(element.getChildren(), "", pName, '$');
                            if (element == null) {
                                return;
                            }
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
                if ((nodeName = TclResolver.getNodeChildName(node)) != null) {
                    e = null;
                    if (nodeName.startsWith("::")) {
                        nodeName = nodeName.substring(2);
                        e = TclResolver.findChildrenByName(nodeName, (IParent)this.sourceModule);
                    } else {
                        e = TclResolver.findChildrenByName(nodeName, element);
                    }
                    if (e == null && this.resolver != null) {
                        e = this.resolver.findElementParent(node, nodeName, element);
                    }
                    if (e != null) {
                        k = selectionElements.iterator();
                        while (k.hasNext()) {
                            ke = k.next();
                            if (!nodeName.equals(ke.getElementName())) continue;
                            k.remove();
                        }
                        selectionElements.add(e);
                    }
                }
                return;
            }
            if (nde.sourceStart() > node.sourceStart() || node.sourceEnd() > nde.sourceEnd()) continue;
            if (nde instanceof TypeDeclaration) {
                type = (TypeDeclaration)nde;
                typeName = TclResolver.getNodeChildName((ASTNode)type);
                e = TclResolver.findChildrenByName(typeName, element);
                if (e == null && type.getName().startsWith("::")) {
                    try {
                        e = (IModelElement)TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", type.getName().replaceAll("::", "\\$"), '$');
                    }
                    catch (ModelException e1) {
                        e1.printStackTrace();
                    }
                }
                if (e instanceof IParent) {
                    stats = ((TypeDeclaration)nde).getStatements();
                    this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
                }
            } else if (nde instanceof MethodDeclaration) {
                this.searchInMethod(node, element, nde, selectionElements);
            } else {
                e = element;
                statements2 = TclResolver.findExtractBlocks(nde);
                if (statements2.size() > 0) {
                    this.searchAddElementsTo(statements2, node, e, selectionElements);
                }
            }
            return;
        }
    }

    public static IModelElement findChildrenByName(String childName, IParent element) {
        block12: {
            block11: {
                if (element != null) break block11;
                return null;
            }
            try {
                IModelElement[] children;
                String nextName = null;
                int pos = childName.indexOf("::");
                if (pos != -1) {
                    nextName = childName.substring(pos + 2);
                    String[] split = TclParseUtil.tclSplit(childName);
                    if (split.length > 0) {
                        childName = split[0];
                    }
                }
                if ((children = element.getChildren()) != null) {
                    int i = 0;
                    while (i < children.length) {
                        String name = children[i].getElementName();
                        if (children[i] instanceof IField && name.indexOf(40) != -1) {
                            name = name.substring(0, name.indexOf(40));
                        }
                        if (name.equals(childName)) {
                            if (nextName == null) {
                                return children[i];
                            }
                            if (children[i] instanceof IParent) {
                                return TclResolver.findChildrenByName(nextName, (IParent)children[i]);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block12;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IParent findTypeFrom(IModelElement[] childs, String name, String parentName, char delimiter) {
        block6: {
            try {
                int i = 0;
                while (i < childs.length) {
                    if (childs[i] instanceof IType) {
                        IType type = (IType)childs[i];
                        String qname = String.valueOf(name) + delimiter + type.getElementName();
                        if (qname.equals(parentName)) {
                            return type;
                        }
                        IParent val = TclResolver.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                        if (val != null) {
                            return val;
                        }
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getNodeChildName(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            String name = method.getName();
            if (name.indexOf("::") != -1) {
                return name.substring(name.lastIndexOf("::") + 2);
            }
            return name;
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)node;
            String name = type.getName();
            return name;
        }
        if (node instanceof TclStatement) {
            String[] var = OldTclParserUtils.returnVariable((TclStatement)node);
            if (var != null) {
                return var[0];
            }
        } else if (node instanceof FieldDeclaration) {
            return ((FieldDeclaration)node).getName();
        }
        return null;
    }

    public void searchInMethod(ASTNode node, IParent element, ASTNode nde, List selectionElements) {
        String pName;
        MethodDeclaration method = (MethodDeclaration)nde;
        String methodName = method.getName();
        if (methodName.indexOf("::") != -1) {
            pName = methodName.substring(0, methodName.lastIndexOf("::"));
            if ((pName = pName.replaceAll("::", "\\$")).equals("$")) {
                element = this.sourceModule;
            } else {
                try {
                    element = TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                    if (element == null) {
                        return;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                    return;
                }
            }
            methodName = TclResolver.getNodeChildName(nde);
        } else if (method.getDeclaringTypeName() != null) {
            pName = method.getDeclaringTypeName();
            if (!pName.startsWith("::")) {
                pName = "$" + pName;
            }
            if ((pName = pName.replaceAll("::", "\\$")).equals("$")) {
                element = this.sourceModule;
            } else {
                try {
                    element = TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", pName, '$');
                    if (element == null) {
                        return;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                    return;
                }
            }
            methodName = TclResolver.getNodeChildName(nde);
        }
        IModelElement e = TclResolver.findChildrenByName(methodName, element);
        if (e != null && e instanceof IParent) {
            List stats = ((MethodDeclaration)nde).getStatements();
            this.searchAddElementsTo(stats, node, (IParent)e, selectionElements);
        }
    }

    public static List findExtractBlocks(ASTNode node) {
        ArrayList statements2;
        block2: {
            statements2 = new ArrayList();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(Expression s) throws Exception {
                    if (s instanceof Block) {
                        statements2.addAll(((Block)s).getStatements());
                    }
                    return super.visit(s);
                }
            };
            try {
                node.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return statements2;
    }

    public static List processReferenceModules(List packages, IScriptProject scriptProject) {
        HashSet<Object> allModules = new HashSet<Object>();
        ArrayList<Object> orderedModules = new ArrayList<Object>();
        List required = packages;
        for (String requiredPackage : required) {
            String pattern = TclPackage.makeSearchRequest("provide", requiredPackage);
            ISourceModule[] modules = TclMixinModel.getInstance().getMixin(scriptProject).findModules(pattern);
            int i = 0;
            while (i < modules.length) {
                block9: {
                    String name = modules[i].getElementName();
                    if (name.equalsIgnoreCase("pkgindex.tcl") || name.equalsIgnoreCase("tclindex")) {
                        IParent parent = (IParent)modules[i].getParent();
                        try {
                            IModelElement[] children = parent.getChildren();
                            int j = 0;
                            while (j < children.length) {
                                IModelElement child = children[j];
                                if (allModules.add(child)) {
                                    orderedModules.add(child);
                                }
                                ++j;
                            }
                            break block9;
                        }
                        catch (ModelException e) {
                            if (DLTKCore.DEBUG) {
                                e.printStackTrace();
                            }
                            break block9;
                        }
                    }
                    if (allModules.add(modules[i])) {
                        orderedModules.add(modules[i]);
                    }
                }
                ++i;
            }
        }
        return orderedModules;
    }

    public static IModelElement[] complexFilter(IModelElement[] elements, IScriptProject scriptProject, TclBuildPathPackageCollector packageCollector, boolean allVariantsOnFailed) {
        if (elements == null || elements.length == 0) {
            return new IModelElement[0];
        }
        HashMap similars = new HashMap();
        int i = 0;
        while (i < elements.length) {
            List<IModelElement> similar;
            IModelElement element = elements[i];
            String fullyQualifiedName = TclParseUtil.getFQNFromModelElement(element, "::");
            if (similars.containsKey(fullyQualifiedName)) {
                similar = (List)similars.get(fullyQualifiedName);
                similar.add(element);
            } else {
                similar = new ArrayList();
                similar.add(element);
                similars.put(fullyQualifiedName, similar);
            }
            ++i;
        }
        boolean processRequire = false;
        ArrayList result = new ArrayList();
        List allModules = null;
        for (List similar : similars.values()) {
            if (similar.size() == 1) {
                result.add(similar.get(0));
                continue;
            }
            if (!processRequire) {
                processRequire = true;
                List<TclPackageDeclaration> directives = packageCollector.getRequireDirectives();
                ArrayList<String> required = new ArrayList<String>();
                for (TclPackageDeclaration decl : directives) {
                    required.add(decl.getName());
                }
                allModules = TclResolver.processReferenceModules(required, scriptProject);
            }
            if (allModules == null) continue;
            IModelElement found = null;
            int index = -1;
            for (IModelElement element : similar) {
                ISourceModule module = (ISourceModule)element.getAncestor(5);
                int indexOf = allModules.indexOf(module);
                if (indexOf == -1 || indexOf <= index) continue;
                found = element;
                index = indexOf;
            }
            if (found == null) {
                if (allVariantsOnFailed) {
                    result.addAll(similar);
                    continue;
                }
                result.add(similar.get(0));
                continue;
            }
            result.add(found);
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public static interface IResolveElementParent {
        public IModelElement findElementParent(ASTNode var1, String var2, IParent var3);
    }
}

