/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.search.DLTKElementMatch;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResultPage;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.search.IMatchPresentation;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class SearchLabelProvider
extends AppearanceAwareLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.dltk.search.matchCount";
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    protected static final long DEFAULT_SEARCH_TEXTFLAGS = 564186904002571L;
    protected static final int DEFAULT_SEARCH_IMAGEFLAGS = 1;
    private Color fPotentialMatchFgColor;
    private Map<IMatchPresentation, ILabelProvider> fLabelProviderMap;
    protected DLTKSearchResultPage fPage;
    private ScopedPreferenceStore fSearchPreferences;
    private IPropertyChangeListener fSearchPropertyListener;

    public SearchLabelProvider(DLTKSearchResultPage page) {
        super(564186904002571L, 1, DLTKUIPlugin.getDefault().getPreferenceStore());
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add language dependent preference store support here...");
        }
        this.addLabelDecorator(new ProblemsLabelDecorator());
        this.fPage = page;
        this.fLabelProviderMap = new HashMap<IMatchPresentation, ILabelProvider>(5);
        this.fSearchPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.search");
        this.fSearchPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchLabelProvider.this.doSearchPropertyChange(event);
            }
        };
        this.fSearchPreferences.addPropertyChangeListener(this.fSearchPropertyListener);
    }

    final void doSearchPropertyChange(PropertyChangeEvent event) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if (POTENTIAL_MATCH_FG_COLOR.equals(event.getProperty()) || EMPHASIZE_POTENTIAL_MATCHES.equals(event.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent lpEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(lpEvent);
        }
    }

    public Color getForeground(Object element) {
        if (this.arePotentialMatchesEmphasized() && this.getNumberOfPotentialMatches(element) > 0) {
            return this.getForegroundColor();
        }
        return super.getForeground(element);
    }

    private Color getForegroundColor() {
        if (this.fPotentialMatchFgColor == null) {
            this.fPotentialMatchFgColor = new Color((Device)DLTKUIPlugin.getActiveWorkbenchShell().getDisplay(), this.getPotentialMatchForegroundColor());
        }
        return this.fPotentialMatchFgColor;
    }

    protected final int getNumberOfPotentialMatches(Object element) {
        int res = 0;
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result != null) {
            Match[] matches = result.getMatches(element);
            int i = 0;
            while (i < matches.length) {
                if (matches[i] instanceof DLTKElementMatch && ((DLTKElementMatch)matches[i]).getAccuracy() == 1) {
                    ++res;
                }
                ++i;
            }
        }
        return res;
    }

    protected final String getLabelWithCounts(Object element, String elementName) {
        int matchCount = this.fPage.getDisplayedMatchCount(element);
        int potentialCount = this.getNumberOfPotentialMatches(element);
        if (matchCount < 2) {
            if (matchCount == 1 && this.hasChildren(element)) {
                if (potentialCount > 0) {
                    return Messages.format(SearchMessages.SearchLabelProvider_potential_singular, elementName);
                }
                return Messages.format(SearchMessages.SearchLabelProvider_exact_singular, elementName);
            }
            if (potentialCount > 0) {
                return Messages.format(SearchMessages.SearchLabelProvider_potential_noCount, elementName);
            }
            return Messages.format(SearchMessages.SearchLabelProvider_exact_noCount, elementName);
        }
        int exactCount = matchCount - potentialCount;
        if (potentialCount > 0 && exactCount > 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount), String.valueOf(exactCount), String.valueOf(potentialCount)};
            return Messages.format(SearchMessages.SearchLabelProvider_exact_and_potential_plural, args);
        }
        if (exactCount == 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount)};
            return Messages.format(SearchMessages.SearchLabelProvider_potential_plural, args);
        }
        Object[] args = new String[]{elementName, String.valueOf(matchCount)};
        return Messages.format(SearchMessages.SearchLabelProvider_exact_plural, args);
    }

    protected boolean hasChildren(Object elem) {
        return false;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
        }
        this.fSearchPreferences.removePropertyChangeListener(this.fSearchPropertyListener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.dispose();
        }
        this.fSearchPreferences = null;
        this.fSearchPropertyListener = null;
        this.fLabelProviderMap.clear();
        super.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.addListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        if (PROPERTY_MATCH_COUNT.equals(property)) {
            return true;
        }
        return this.getLabelProvider(element).isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        for (ILabelProvider labelProvider : this.fLabelProviderMap.values()) {
            labelProvider.removeListener(listener);
        }
    }

    protected String getParticipantText(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        return "";
    }

    protected Image getParticipantImage(Object element) {
        ILabelProvider lp = this.getLabelProvider(element);
        if (lp == null) {
            return null;
        }
        return lp.getImage(element);
    }

    private ILabelProvider getLabelProvider(Object element) {
        IMatchPresentation participant = ((DLTKSearchResult)this.fPage.getInput()).getSearchParticpant(element);
        if (participant == null) {
            return null;
        }
        ILabelProvider lp = this.fLabelProviderMap.get(participant);
        if (lp == null) {
            lp = participant.createLabelProvider();
            this.fLabelProviderMap.put(participant, lp);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                lp.addListener((ILabelProviderListener)listeners[i]);
                ++i;
            }
        }
        return lp;
    }

    private boolean arePotentialMatchesEmphasized() {
        return this.fSearchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    private RGB getPotentialMatchForegroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fSearchPreferences, (String)POTENTIAL_MATCH_FG_COLOR);
    }
}

