/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.utils.CorePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTNode
implements ISourceNode {
    public static final int Bit1 = 1;
    public static final int Bit2 = 2;
    public static final int Bit3 = 4;
    public static final int Bit4 = 8;
    public static final int Bit5 = 16;
    public static final int Bit6 = 32;
    public static final int Bit7 = 64;
    public static final int Bit8 = 128;
    public static final int Bit9 = 256;
    public static final int Bit10 = 512;
    public static final int Bit11 = 1024;
    public static final int Bit12 = 2048;
    public static final int Bit13 = 4096;
    public static final int Bit14 = 8192;
    public static final int Bit15 = 16384;
    public static final int Bit16 = 32768;
    public static final int Bit17 = 65536;
    public static final int Bit18 = 131072;
    public static final int Bit19 = 262144;
    public static final int Bit20 = 524288;
    public static final int Bit21 = 0x100000;
    public static final int Bit22 = 0x200000;
    public static final int Bit23 = 0x400000;
    public static final int Bit24 = 0x800000;
    public static final int Bit25 = 0x1000000;
    public static final int Bit26 = 0x2000000;
    public static final int Bit27 = 0x4000000;
    public static final int Bit28 = 0x8000000;
    public static final int Bit29 = 0x10000000;
    public static final int Bit30 = 0x20000000;
    public static final int Bit31 = 0x40000000;
    public static final int Bit32 = Integer.MIN_VALUE;
    public static final long Bit32L = 0x80000000L;
    public static final long Bit33L = 0x100000000L;
    public static final long Bit34L = 0x200000000L;
    public static final long Bit35L = 0x400000000L;
    public static final long Bit36L = 0x800000000L;
    public static final long Bit37L = 0x1000000000L;
    public static final long Bit38L = 0x2000000000L;
    public static final long Bit39L = 0x4000000000L;
    public static final long Bit40L = 0x8000000000L;
    public static final long Bit41L = 0x10000000000L;
    public static final long Bit42L = 0x20000000000L;
    public static final long Bit43L = 0x40000000000L;
    public static final long Bit44L = 0x80000000000L;
    public static final long Bit45L = 0x100000000000L;
    public static final long Bit46L = 0x200000000000L;
    public static final long Bit47L = 0x400000000000L;
    public static final long Bit48L = 0x800000000000L;
    public static final long Bit49L = 0x1000000000000L;
    public static final long Bit50L = 0x2000000000000L;
    public static final long Bit51L = 0x4000000000000L;
    public static final long Bit52L = 0x8000000000000L;
    public static final long Bit53L = 0x10000000000000L;
    public static final long Bit54L = 0x20000000000000L;
    public static final long Bit55L = 0x40000000000000L;
    public static final long Bit56L = 0x80000000000000L;
    public static final long Bit57L = 0x100000000000000L;
    public static final long Bit58L = 0x200000000000000L;
    public static final long Bit59L = 0x400000000000000L;
    public static final long Bit60L = 0x800000000000000L;
    public static final long Bit61L = 0x1000000000000000L;
    public static final long Bit62L = 0x2000000000000000L;
    public static final long Bit63L = 0x4000000000000000L;
    public static final long Bit64L = Long.MIN_VALUE;
    public static final int D_METHOD_DECL = 1;
    public static final int D_TYPE_DECL = 2;
    public static final int D_VAR_DECL = 3;
    private int sourceStart;
    private int sourceEnd;

    protected ASTNode() {
        this(0, 0);
    }

    protected ASTNode(int start, int end) {
        this.sourceStart = start;
        this.sourceEnd = end;
    }

    protected ASTNode(DLTKToken token) {
        this.sourceStart = token.getColumn();
        String tokenValue = token.getText();
        this.sourceEnd = tokenValue != null ? this.sourceStart + tokenValue.length() : this.sourceStart;
    }

    public final int sourceStart() {
        return this.sourceStart;
    }

    @Override
    public int start() {
        return this.sourceStart();
    }

    public final int sourceEnd() {
        return this.sourceEnd;
    }

    @Override
    public int end() {
        return this.sourceEnd();
    }

    public int matchStart() {
        return this.sourceStart();
    }

    public int matchLength() {
        return this.sourceEnd() - this.sourceStart();
    }

    public void setStart(int start) {
        this.sourceStart = start;
    }

    public void setEnd(int end) {
        this.sourceEnd = end;
    }

    public abstract void traverse(ASTVisitor var1) throws Exception;

    public void printNode(CorePrinter output) {
        output.println(this.getClass() + " (node doesn't support debug printing)");
    }

    protected ISourceRange getSourceRange() {
        return new SourceRange(this.sourceStart(), this.sourceEnd() - this.sourceStart() + 1);
    }

    private static String simplifyClassName(String name) {
        int pos = name.lastIndexOf(46);
        return name.substring(pos + 1);
    }

    public String debugString() {
        return String.valueOf(ASTNode.simplifyClassName(this.getClass().getName())) + "@" + this.getSourceRange().toString();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        CorePrinter printer = new CorePrinter(writer);
        this.printNode(printer);
        printer.flush();
        printer.close();
        return writer.getBuffer().toString();
    }

    public List<ASTNode> getChilds() {
        ArrayList<ASTNode> result;
        block2: {
            result = new ArrayList<ASTNode>();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (node == ASTNode.this) {
                        return true;
                    }
                    result.add(node);
                    return false;
                }
            };
            try {
                this.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean locationMatches(ASTNode other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.sourceEnd() >= 0 && other.sourceStart() >= 0 && this.sourceStart() == other.sourceStart() && this.sourceEnd() == other.sourceEnd();
    }
}

