/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.util.Util;

public abstract class AbstractJob
implements IJob {
    public static final boolean DEBUG = false;
    protected boolean isCancelled = false;
    private String savedName;

    public boolean belongsTo(String jobFamily) {
        return false;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void ensureReadyToRun() {
    }

    protected abstract String getName();

    protected void log(Object message) {
        System.out.println(String.valueOf('[') + this.toString() + "] " + message);
    }

    private final String getShortClassName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        String shortClassName = this.getShortClassName();
        if (this.savedName == null) {
            try {
                this.savedName = this.getName();
            }
            catch (Exception e) {
                this.savedName = "<Unknown>";
                Util.log(e, String.valueOf(shortClassName) + " getName() error");
            }
        }
        return String.valueOf(shortClassName) + '|' + this.savedName;
    }

    public final boolean execute(IProgressMonitor monitor) {
        try {
            long startTime = 0L;
            this.run();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected abstract void run() throws CoreException, IOException;
}

