/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathChange;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ChangeBuildpathOperation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.ScriptProject;

public class SetBuildpathOperation
extends ChangeBuildpathOperation {
    IBuildpathEntry[] newRawPath;
    ScriptProject project;

    public SetBuildpathOperation(ScriptProject project, IBuildpathEntry[] newRawPath, boolean canChangeResource) {
        super(new IModelElement[]{project}, canChangeResource);
        this.newRawPath = newRawPath;
        this.project = project;
    }

    protected void executeOperation() throws ModelException {
        this.checkCanceled();
        try {
            ModelManager.PerProjectInfo perProjectInfo = this.project.getPerProjectInfo();
            BuildpathChange buildpathChange = perProjectInfo.setRawBuildpath(this.newRawPath, ModelStatus.VERIFIED_OK);
            this.buildpathChanged(buildpathChange);
            if (this.canChangeResources && perProjectInfo.writeAndCacheBuildpath(this.project, this.newRawPath)) {
                this.setAttribute("hasModifiedResource", "true");
            }
        }
        finally {
            this.done();
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        if (this.canChangeResources) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule((IResource)this.project.getProject()), ruleFactory.modifyRule((IResource)ModelManager.getExternalManager().getExternalFoldersProject())});
        }
        return super.getSchedulingRule();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetBuildpathOperation\n");
        buffer.append(" - buildpath : ");
        buffer.append("{");
        int i = 0;
        while (i < this.newRawPath.length) {
            if (i > 0) {
                buffer.append(",");
            }
            IBuildpathEntry element = this.newRawPath[i];
            buffer.append(" ").append(element.toString());
            ++i;
        }
        return buffer.toString();
    }

    public IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        this.project.flushBuildpathProblemMarkers(false, false);
        return BuildpathEntry.validateBuildpath(this.project, this.newRawPath);
    }
}

