/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyEvaluatorFactory;
import org.eclipse.dltk.ti.DefaultTypeInferencer;
import org.eclipse.dltk.ti.EvaluatorStatistics;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.IPruner;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubyTypeInferencer
extends DefaultTypeInferencer {
    public RubyTypeInferencer() {
        super((IGoalEvaluatorFactory)new RubyEvaluatorFactory());
    }

    public synchronized IEvaluatedType evaluateType(AbstractTypeGoal goal, int timeLimit) {
        Object type = super.evaluateType(goal, (IPruner)new SimplestRubyPruner(timeLimit));
        if (type == null || type instanceof UnknownType) {
            type = new RubyClassType("Object");
        }
        return type;
    }

    public synchronized Object evaluateGoal(IGoal goal, IPruner pruner) {
        return super.evaluateGoal(goal, pruner);
    }

    private class SimplestRubyPruner
    implements IPruner {
        private long timeStart;
        private final long timeLimit;

        public SimplestRubyPruner(long timeLimit) {
            this.timeLimit = timeLimit;
        }

        public void init() {
            this.timeStart = System.currentTimeMillis();
        }

        public boolean prune(IGoal goal, EvaluatorStatistics stat) {
            long currentTime = System.currentTimeMillis();
            if (this.timeLimit != -1L && currentTime - this.timeStart > this.timeLimit) {
                return true;
            }
            return stat != null && stat.getSubGoalsDoneSuccessful() > 5;
        }
    }
}

