/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public abstract class ConsoleLineNotifier
implements IPatternMatchListener,
IPropertyChangeListener {
    private TextConsole fConsole = null;

    public void connect(TextConsole console) {
        this.fConsole = console;
        this.fConsole.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public synchronized void disconnect() {
        try {
            int lastLine;
            IDocument document = this.fConsole.getDocument();
            if (document != null && document.getLineDelimiter(lastLine = document.getNumberOfLines() - 1) == null) {
                IRegion lineInformation = document.getLineInformation(lastLine);
                this.lineAppended(lineInformation, document.get(lineInformation.getOffset(), lineInformation.getLength()));
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public synchronized void consoleClosed() {
        this.fConsole = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            IDocument document = this.fConsole.getDocument();
            int lineOfOffset = document.getLineOfOffset(event.getOffset());
            String delimiter = document.getLineDelimiter(lineOfOffset);
            int strip = delimiter == null ? 0 : delimiter.length();
            Region region = new Region(event.getOffset(), event.getLength() - strip);
            this.lineAppended((IRegion)region, document.get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException badLocationException) {}
    }

    public abstract void lineAppended(IRegion var1, String var2);

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
            this.fConsole.removePropertyChangeListener((IPropertyChangeListener)this);
            this.consoleClosed();
        }
    }

    public String getPattern() {
        return ".*\\r(\\n?)|.*\\n";
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return "\\n|\\r";
    }
}

