/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.ArgumentMatch;
import org.eclipse.dltk.tcl.ast.AstFactory;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCodeModel;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.internal.parser.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;
import org.eclipse.dltk.tcl.internal.parser.raw.VariableSubstitution;
import org.eclipse.dltk.tcl.parser.ISubstitutionManager;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.ITclParserOptions;
import org.eclipse.dltk.tcl.parser.Messages;
import org.eclipse.dltk.tcl.parser.PerformanceMonitor;
import org.eclipse.dltk.tcl.parser.TclArgumentMatcher;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclParser
implements ITclParserOptions {
    private static final boolean TRACE_PARSER = false;
    private String source;
    private ITclErrorReporter reporter;
    private IScopeProcessor scopeProcessor;
    private int globalOffset = 0;
    private Map<String, Boolean> options = new HashMap<String, Boolean>();
    private String version;

    public TclParser() {
        this(null);
    }

    public TclParser(String version) {
        this.version = version;
        this.setOptionValue("report_unknown_as_error", false);
    }

    public boolean isOptionSet(String option) {
        Boolean bool = this.options.get(option);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public void setOptionValue(String option, boolean value) {
        this.options.put(option, value);
    }

    public List<org.eclipse.dltk.tcl.ast.TclCommand> parse(String source) {
        return this.parse(source, null, null);
    }

    public int getGlobalOffset() {
        return this.globalOffset;
    }

    public void setGlobalOffset(int globalOffset) {
        this.globalOffset = globalOffset;
    }

    public TclModule parseModule(String source, ITclErrorReporter reporter, IScopeProcessor scopeProcessor) {
        TclModule module = AstFactory.eINSTANCE.createTclModule();
        TclCodeModel codeModel = AstFactory.eINSTANCE.createTclCodeModel();
        module.setCodeModel(codeModel);
        module.setSize(source.length() + this.globalOffset);
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)source);
        int[] offsets = tracker.getLineOffsets();
        String[] delimeters = tracker.getDelimeters();
        EList<Integer> loff = codeModel.getLineOffsets();
        int i = 0;
        while (i < offsets.length) {
            loff.add((Object)(offsets[i] + this.globalOffset));
            ++i;
        }
        codeModel.getDelimeters().addAll(Arrays.asList(delimeters));
        this.source = source;
        this.reporter = reporter;
        this.scopeProcessor = scopeProcessor;
        ArrayList<org.eclipse.dltk.tcl.ast.TclCommand> tclCommands = new ArrayList<org.eclipse.dltk.tcl.ast.TclCommand>();
        this.parseToBlock(tclCommands, source, 0);
        module.getStatements().addAll(tclCommands);
        return module;
    }

    public List<org.eclipse.dltk.tcl.ast.TclCommand> parse(String source, ITclErrorReporter reporter, IScopeProcessor scopeProcessor) {
        this.source = source;
        this.reporter = reporter;
        this.scopeProcessor = scopeProcessor;
        ArrayList<org.eclipse.dltk.tcl.ast.TclCommand> tclCommands = new ArrayList<org.eclipse.dltk.tcl.ast.TclCommand>();
        this.parseToBlock(tclCommands, source, 0);
        return tclCommands;
    }

    private void parseToBlock(List<org.eclipse.dltk.tcl.ast.TclCommand> block, String partSource, int offset) {
        SimpleTclParser simpleParser = new SimpleTclParser(offset);
        try {
            PerformanceMonitor.getDefault().begin("RAW_PARSE_TIME");
            simpleParser.setProblemReporter(this.reporter);
            TclScript script = simpleParser.parse(partSource);
            PerformanceMonitor.getDefault().end("RAW_PARSE_TIME");
            List<TclCommand> commands = script.getCommands();
            this.processRawCommands(block, offset, commands);
        }
        catch (TclParseException e) {
            e.printStackTrace();
        }
    }

    private void processRawCommands(List<org.eclipse.dltk.tcl.ast.TclCommand> block, int offset, List<TclCommand> commands) {
        for (TclCommand command : commands) {
            org.eclipse.dltk.tcl.ast.TclCommand comm;
            org.eclipse.dltk.tcl.ast.TclCommand st = this.parseTclCommand(command, offset, this.source);
            if (st == null || (comm = this.processTclCommand(st)) == null) continue;
            block.add(comm);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.eclipse.dltk.tcl.ast.TclCommand processTclCommand(org.eclipse.dltk.tcl.ast.TclCommand st) {
        if (this.scopeProcessor == null) {
            return st;
        }
        EList<TclArgument> arguments = st.getArguments();
        TclArgument commandName = st.getName();
        if (commandName instanceof Substitution) {
            this.reportCommandNameSubstitution(commandName);
            return st;
        }
        if (!(commandName instanceof StringArgument)) return st;
        String commandValue = ((StringArgument)commandName).getValue();
        Command[] definitions = this.scopeProcessor.getCommandDefinition(commandValue);
        TclErrorCollector parseErrors = new TclErrorCollector();
        boolean matched = false;
        st.setQualifiedName(this.scopeProcessor.getQualifiedName(commandValue));
        if (definitions != null && definitions.length != 0) {
            int i = 0;
            while (i < definitions.length) {
                this.perf("processTclCommand:" + definitions[i].getName());
                Command definition = definitions[i];
                boolean validVersion = true;
                if (this.version != null && definition.getVersion() != null) {
                    validVersion = TclParserUtils.parseVersion(definition.getVersion(), this.version);
                }
                if (validVersion) {
                    ISubstitutionManager manager = null;
                    if (this.scopeProcessor != null) {
                        manager = this.scopeProcessor.getSubstitutionManager();
                    }
                    TclArgumentMatcher matcher = new TclArgumentMatcher(st, this.options, manager);
                    this.perf("matchTclCommand:" + definitions[i].getName());
                    this.perf("GLOBAL_MATCH_TIME");
                    st.setDefinition(definition);
                    st.setMatched(false);
                    if (matcher.match(definition)) {
                        st.setMatched(true);
                        this.perfDone("matchTclCommand:" + definitions[i].getName());
                        if (definition.getDeprecated() != null && this.version != null && TclParserUtils.parseVersion(definition.getDeprecated(), this.version)) {
                            this.reportDeprecatedError(st, commandValue, definition);
                        }
                        if (!this.scopeProcessor.checkCommandScope(definition)) {
                            this.reportOutOfScopeError(st, commandValue, definition);
                        }
                        this.scopeProcessor.processCommand(st);
                        int[] blockArguments = matcher.getBlockArguments();
                        this.parseReplaceBlockArguments((List<TclArgument>)arguments, blockArguments);
                        TclArgumentMatcher.ComplexArgumentResult[] complexArguments = matcher.getComplexArguments();
                        this.processComplexArguments(arguments, complexArguments);
                        this.scopeProcessor.endProcessCommand();
                        matched = true;
                        this.createMappings(st, matcher);
                    } else {
                        this.perf("matchTclCommand:" + definitions[i].getName());
                    }
                    this.repr("error count:" + definitions[i].getName(), matcher.getErrorReporter().getCount());
                    this.perfDone("GLOBAL_MATCH_TIME");
                    matcher.reportErrors(this.reporter);
                    this.repr("error count:" + definitions[i].getName(), matcher.getErrorReporter().getCount());
                    this.perfDone("processTclCommand:" + definitions[i].getName());
                    return st;
                }
                this.reportInvalidVersion(st, commandValue, parseErrors, definition);
                this.perfDone("processTclCommand:" + definitions[i].getName());
                ++i;
            }
            if (matched) return st;
            parseErrors.reportAll(this.reporter);
            return st;
        } else {
            if (!this.isOptionSet("report_unknown_as_error") || this.reporter == null) return st;
            this.reporter.report(3, String.valueOf(Messages.TclParser_Unknown_Command) + commandValue, null, commandName.getStart(), commandName.getEnd(), ITclErrorReporter.WARNING);
        }
        return st;
    }

    private void createMappings(org.eclipse.dltk.tcl.ast.TclCommand st, TclArgumentMatcher matcher) {
        EList<TclArgument> arguments = st.getArguments();
        EList<ArgumentMatch> matches = st.getMatches();
        Map<Argument, int[]> map = matcher.getMappings();
        for (Argument arg : map.keySet()) {
            int[] positions = map.get(arg);
            ArgumentMatch match = AstFactory.eINSTANCE.createArgumentMatch();
            match.setDefinition(arg);
            int i = 0;
            while (i < positions.length) {
                int start = positions[0];
                int end = positions[1];
                int j = start;
                while (j < end & j < arguments.size()) {
                    match.getArguments().add((Object)((TclArgument)arguments.get(j)));
                    ++j;
                }
                ++i;
            }
            matches.add((Object)match);
        }
    }

    private void processComplexArguments(EList<TclArgument> arguments, TclArgumentMatcher.ComplexArgumentResult[] complexArguments) {
        TclArgumentMatcher.ComplexArgumentResult[] complexArgumentResultArray = complexArguments;
        int n = complexArguments.length;
        int n2 = 0;
        while (n2 < n) {
            TclArgumentMatcher.ComplexArgumentResult arg = complexArgumentResultArray[n2];
            TclArgument original = (TclArgument)arguments.get(arg.getArgumentNumber());
            int[] blockArguments2 = arg.getBlockArguments();
            List<TclArgument> arguments2 = arg.getArguments();
            this.parseReplaceBlockArguments(arguments2, blockArguments2);
            TclArgumentList list = AstFactory.eINSTANCE.createTclArgumentList();
            list.setDefinitionArgument(arg.getDefinition());
            list.getArguments().addAll(arguments2);
            list.setStart(original.getStart());
            list.setEnd(original.getEnd());
            List<TclArgumentMatcher.ComplexArgumentResult> complexArguments2 = arg.getComplexArguments();
            if (complexArguments2.size() > 0) {
                this.processComplexArguments(list.getArguments(), complexArguments2.toArray(new TclArgumentMatcher.ComplexArgumentResult[complexArguments2.size()]));
            }
            arguments.set(arg.getArgumentNumber(), (Object)list);
            list.setKind(0);
            if (original instanceof ComplexString) {
                list.setKind(((ComplexString)original).getKind());
            } else if (original instanceof StringArgument) {
                StringArgument sArg = (StringArgument)original;
                String value = sArg.getValue();
                list.setKind(0);
                if (value.startsWith("{") && value.endsWith("}")) {
                    list.setKind(1);
                }
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    list.setKind(2);
                }
            }
            ++n2;
        }
    }

    private void perf(String name) {
        PerformanceMonitor.getDefault().begin(name);
    }

    private void perfDone(String name) {
        PerformanceMonitor.getDefault().end(name);
    }

    private void repr(String name, int count) {
        PerformanceMonitor.getDefault().add(name, count);
    }

    private void parseReplaceBlockArguments(List<TclArgument> arguments, int[] blockArguments) {
        int i = 0;
        while (i < blockArguments.length) {
            StringArgument blockCode = (StringArgument)arguments.get(blockArguments[i]);
            Script script = AstFactory.eINSTANCE.createScript();
            script.setStart(blockCode.getStart());
            script.setEnd(blockCode.getEnd());
            String wordText = blockCode.getValue();
            if (wordText.startsWith("{") && wordText.endsWith("}") || wordText.startsWith("[") && wordText.endsWith("]") || wordText.startsWith("\"") && wordText.endsWith("\"")) {
                script.setContentStart(script.getStart() + 1);
                script.setContentEnd(script.getEnd() - 1);
                this.parseToBlock((List<org.eclipse.dltk.tcl.ast.TclCommand>)script.getCommands(), wordText.substring(1, wordText.length() - 1), script.getContentStart() - this.globalOffset);
            } else {
                script.setContentStart(script.getStart());
                script.setContentEnd(script.getEnd());
                this.parseToBlock((List<org.eclipse.dltk.tcl.ast.TclCommand>)script.getCommands(), wordText, blockCode.getStart() - this.globalOffset);
            }
            arguments.set(blockArguments[i], script);
            ++i;
        }
    }

    private org.eclipse.dltk.tcl.ast.TclCommand parseTclCommand(TclCommand command, int offset, String content) {
        try {
            AstFactory factory = AstFactory.eINSTANCE;
            org.eclipse.dltk.tcl.ast.TclCommand tclCommand = factory.createTclCommand();
            List<TclWord> words = command.getWords();
            boolean name = true;
            int start = -1;
            for (TclWord word : words) {
                if (start == -1) {
                    start = word.getStart();
                }
                TclArgument exp = null;
                List<Object> contents = word.getContents();
                if (contents.size() == 1) {
                    Object o = contents.get(0);
                    exp = this.processWordContentAsExpression(offset, content, factory, word.getStart(), word.getEnd(), o);
                } else if (contents.size() > 1) {
                    ComplexString literal = this.makeComplexString(offset, content, factory, word.getStart(), word.getEnd(), contents);
                    exp = literal;
                }
                if (name) {
                    tclCommand.setName(exp);
                    name = false;
                    continue;
                }
                tclCommand.getArguments().add(exp);
            }
            tclCommand.setStart(start + offset + this.globalOffset);
            tclCommand.setEnd(command.getEnd() + offset + 1 + this.globalOffset);
            return tclCommand;
        }
        catch (StringIndexOutOfBoundsException bounds) {
            if (DLTKCore.DEBUG) {
                bounds.printStackTrace();
            }
            if (this.reporter != null) {
                this.reporter.report(2, bounds.getMessage(), null, 0, 0, ITclErrorReporter.ERROR);
            }
            return null;
        }
    }

    private TclArgument processWordContentAsExpression(int offset, String content, AstFactory factory, int start, int end, Object o) {
        TclArgument exp;
        if (o instanceof QuotesSubstitution) {
            QuotesSubstitution qs = (QuotesSubstitution)o;
            List<Object> contents = qs.getContents();
            if (contents.size() == 1) {
                String wordText = null;
                wordText = content.substring(offset + start, offset + end + 1);
                StringArgument literal = factory.createStringArgument();
                literal.setStart(offset + qs.getStart() + this.globalOffset);
                literal.setEnd(offset + qs.getEnd() + 1 + this.globalOffset);
                literal.setValue(wordText);
                literal.setRawValue(wordText);
                exp = literal;
            } else {
                ComplexString literal;
                exp = literal = this.makeComplexString(offset, content, factory, qs.getStart(), qs.getEnd(), contents);
            }
        } else if (o instanceof BracesSubstitution) {
            String wordText = null;
            wordText = content.substring(start + offset, end + offset + 1);
            BracesSubstitution bs = (BracesSubstitution)o;
            StringArgument block = factory.createStringArgument();
            block.setStart(offset + bs.getStart() + this.globalOffset);
            block.setEnd(offset + bs.getEnd() + 1 + this.globalOffset);
            block.setValue(wordText);
            block.setRawValue(wordText);
            exp = block;
        } else if (o instanceof CommandSubstitution) {
            CommandSubstitution bs = (CommandSubstitution)o;
            Substitution bl = factory.createSubstitution();
            bl.setStart(offset + bs.getStart() + this.globalOffset);
            bl.setEnd(offset + bs.getEnd() + 1 + this.globalOffset);
            TclScript script = bs.getScript();
            this.processRawCommands((List<org.eclipse.dltk.tcl.ast.TclCommand>)bl.getCommands(), offset, script.getCommands());
            exp = bl;
        } else if (o instanceof VariableSubstitution) {
            VariableSubstitution bs = (VariableSubstitution)o;
            VariableReference ref = factory.createVariableReference();
            ref.setStart(offset + bs.getStart() + this.globalOffset);
            ref.setEnd(offset + bs.getEnd() + 1 + this.globalOffset);
            ref.setName(bs.getName());
            TclWord index = bs.getIndex();
            if (index != null) {
                ComplexString literal;
                if (index.getContents().size() == 1) {
                    TclArgument a = this.processWordContentAsExpression(offset, content, factory, index.getStart(), index.getEnd(), index.getContents().get(0));
                    if (a != null) {
                        ref.setIndex(a);
                    }
                } else if (index.getContents().size() > 1 && (literal = this.makeComplexString(offset, content, factory, index.getStart(), index.getEnd(), index.getContents())) != null) {
                    ref.setIndex(literal);
                }
            }
            exp = ref;
        } else {
            String wordText = null;
            wordText = content.substring(offset + start, offset + end + 1);
            StringArgument reference = factory.createStringArgument();
            reference.setStart(offset + start + this.globalOffset);
            reference.setEnd(offset + end + 1 + this.globalOffset);
            reference.setValue(wordText);
            reference.setRawValue(wordText);
            exp = reference;
        }
        return exp;
    }

    private ComplexString makeComplexString(int offset, String content, AstFactory factory, int start, int end, List<Object> contents) {
        ComplexString literal = factory.createComplexString();
        literal.setStart(offset + start + this.globalOffset);
        literal.setEnd(offset + end + 1 + this.globalOffset);
        String value = content.substring(offset + start, offset + end + 1);
        literal.setKind(0);
        int pos = start;
        if (value.startsWith("{") && value.endsWith("}")) {
            literal.setKind(1);
            ++pos;
        } else if (value.startsWith("\"") && value.endsWith("\"")) {
            literal.setKind(2);
            ++pos;
        }
        int i = 0;
        while (i < contents.size()) {
            Object oo = contents.get(i);
            if (oo instanceof String) {
                String st = (String)oo;
                StringArgument a = factory.createStringArgument();
                a.setValue(st);
                a.setRawValue(st);
                a.setStart(pos + offset + this.globalOffset);
                a.setEnd((pos += st.length()) + offset + this.globalOffset);
                literal.getArguments().add((Object)a);
            } else if (oo instanceof ISubstitution && oo instanceof TclElement) {
                TclElement bs = (TclElement)oo;
                pos = bs.getEnd() + 1;
                TclArgument expr = this.processWordContentAsExpression(offset, content, factory, bs.getStart(), bs.getEnd(), bs);
                if (expr != null) {
                    literal.getArguments().add((Object)expr);
                }
            }
            ++i;
        }
        return literal;
    }

    private void reportCommandNameSubstitution(TclArgument commandName) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(12, Messages.TclParser_Command_Name_Is_Substitution, null, commandName.getStart(), commandName.getEnd(), ITclErrorReporter.WARNING);
    }

    private void reportDeprecatedError(org.eclipse.dltk.tcl.ast.TclCommand st, String commandValue, Command definition) {
        if (this.reporter == null) {
            return;
        }
        String message = NLS.bind((String)Messages.TclParser_Command_Is_Deprecated, (Object[])new Object[]{commandValue, definition.getDeprecated()});
        this.reporter.report(14, message, null, st.getStart(), st.getEnd(), ITclErrorReporter.WARNING);
    }

    private void reportInvalidVersion(org.eclipse.dltk.tcl.ast.TclCommand st, String commandValue, TclErrorCollector parseErrors, Command definition) {
        String message = NLS.bind((String)Messages.TclParser_Command_Version_Is_Invalid, (Object[])new Object[]{commandValue, definition.getVersion()});
        parseErrors.report(13, message, null, st.getStart(), st.getEnd(), ITclErrorReporter.ERROR);
    }

    private void reportOutOfScopeError(org.eclipse.dltk.tcl.ast.TclCommand st, String commandValue, Command definition) {
        if (this.reporter == null) {
            return;
        }
        EList<Command> scopes = definition.getScope();
        StringBuilder scopesList = new StringBuilder();
        int i = 0;
        while (i < scopes.size()) {
            if (i == scopes.size() - 1) {
                scopesList.append(" or ");
            } else if (i != 0) {
                scopesList.append(", ");
            }
            scopesList.append(((Command)scopes.get(i)).getName());
            ++i;
        }
        String message = NLS.bind((String)Messages.TclParser_Command_Out_Of_Scope, (Object[])new Object[]{commandValue, scopesList});
        this.reporter.report(15, message, null, st.getStart(), st.getEnd(), ITclErrorReporter.ERROR);
    }
}

