/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.mylyn.DLTKStructureBridge;
import org.eclipse.dltk.launching.sourcelookup.ScriptSourceLookupDirector;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLTKDebugStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "DLTK/debug";
    private final DLTKStructureBridge javaStructureBridge = new DLTKStructureBridge();
    private final Map<ScriptStackFrame, IModelElement> stackFrameMap = new WeakHashMap<ScriptStackFrame, IModelElement>();

    public boolean acceptsObject(Object object) {
        return object instanceof ILaunch || object instanceof ScriptDebugElement || object instanceof RuntimeProcess;
    }

    public boolean canBeLandmark(String handle) {
        return false;
    }

    public boolean canFilter(Object element) {
        if (element instanceof ScriptStackFrame) {
            ScriptStackFrame stackFrame = (ScriptStackFrame)element;
            try {
                IStackFrame[] frames = stackFrame.getThread().getStackFrames();
                int indexOfInterestingFrame = 0;
                int indexOfCurrentFrame = 0;
                int i = 0;
                while (i < frames.length) {
                    IInteractionElement correspondingElement;
                    IStackFrame frame = frames[i];
                    if (stackFrame.getName().equals(frame.getName())) {
                        indexOfCurrentFrame = i;
                    }
                    if ((correspondingElement = ContextCore.getContextManager().getElement(this.getHandleIdentifier(frame))) != null && correspondingElement.getInterest().isInteresting()) {
                        indexOfInterestingFrame = i;
                    }
                    ++i;
                }
                return indexOfCurrentFrame > indexOfInterestingFrame;
            }
            catch (DebugException e) {
                return false;
            }
        }
        return element instanceof ScriptStackFrame;
    }

    public List<String> getChildHandles(String handle) {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame stackFrame = (ScriptStackFrame)object;
            IModelElement type = null;
            if (this.stackFrameMap.containsKey(stackFrame)) {
                type = this.stackFrameMap.get(stackFrame);
            } else {
                try {
                    ScriptSourceLookupDirector director = new ScriptSourceLookupDirector();
                    Object[] elements = director.findSourceElements(object);
                    if (elements != null && elements.length > 0) {
                        this.stackFrameMap.put(stackFrame, (IModelElement)elements[0]);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (type != null && type.exists()) {
                return this.javaStructureBridge.getHandleIdentifier(type);
            }
        }
        return null;
    }

    public String getLabel(Object object) {
        return "" + object;
    }

    public Object getObjectForHandle(String handle) {
        return this.javaStructureBridge.getObjectForHandle(handle);
    }

    public String getParentHandle(String handle) {
        return null;
    }

    public boolean isDocument(String handle) {
        return false;
    }
}

