/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IExecutionLogger;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.rse.services.shells.HostShellOutputStream;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class MyHostShellProcessAdapter
extends Process
implements IHostShellOutputListener {
    private final IExecutionLogger logger;
    private IHostShell hostShell;
    private PipedInputStream inputStream = null;
    private PipedInputStream errorStream = null;
    private HostShellOutputStream outputStream = null;
    private PipedOutputStream hostShellInput = null;
    private PipedOutputStream hostShellError = null;
    private String pattern1;
    private boolean done = false;
    static final String CTRL_C = "\u0003";
    private int prefixCounter = 0;

    public MyHostShellProcessAdapter(IHostShell hostShell, String pattern1, IExecutionLogger logger) throws IOException {
        this.logger = logger;
        this.hostShell = hostShell;
        this.pattern1 = pattern1;
        this.hostShellInput = new PipedOutputStream();
        this.hostShellError = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.hostShellInput);
        this.errorStream = new PipedInputStream(this.hostShellError);
        this.outputStream = new HostShellOutputStream(hostShell);
        IHostShellOutputReader outputReader = this.hostShell.getStandardOutputReader();
        if (outputReader != null) {
            outputReader.addOutputListener((IHostShellOutputListener)this);
        }
        if ((outputReader = this.hostShell.getStandardErrorReader()) != null) {
            outputReader.addOutputListener((IHostShellOutputListener)this);
        }
    }

    public synchronized void destroy() {
        if (!this.done && this.hostShell.isActive()) {
            this.hostShell.writeToShell(CTRL_C);
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.hostShell.exit();
        this.notifyAll();
        this.closeStreams();
    }

    private void closeStreams() {
        this.closeStreams(new Object[]{this.hostShellInput, this.hostShellError, this.inputStream, this.errorStream, this.outputStream});
    }

    private void closeStreams(Object[] streams) {
        int i = 0;
        while (i < streams.length) {
            Object stream = streams[i];
            if (stream != null) {
                if (stream instanceof InputStream) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                } else if (stream instanceof OutputStream) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    DLTKRSEPlugin.log("closeStream(" + stream.getClass().getName() + ")");
                }
            }
            ++i;
        }
    }

    public synchronized int exitValue() {
        if (!this.done && this.hostShell.isActive()) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.done && this.hostShell.isActive()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            this.wait(1000L);
            if (this.inputStream.available() != 0 || this.errorStream.available() != 0) {
                throw new InterruptedException();
            }
            this.hostShell.exit();
            this.closeStreams();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private synchronized void endOfOutput() {
        this.done = true;
        this.notifyAll();
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] input = event.getLines();
        PipedOutputStream outputStream = event.isError() ? this.hostShellError : this.hostShellInput;
        try {
            int i = 0;
            while (i < input.length) {
                String line = input[i].getString();
                if (this.logger != null) {
                    this.logger.logLine(line);
                }
                if (line != null) {
                    String trimLine;
                    if (!event.isError() && (trimLine = line.trim()).endsWith(this.pattern1)) {
                        if (this.prefixCounter == 1 && !trimLine.equals(this.pattern1)) {
                            int pos = line.indexOf(this.pattern1);
                            outputStream.write(line.substring(0, pos).getBytes());
                            ((OutputStream)outputStream).write(10);
                            ((OutputStream)outputStream).flush();
                        }
                        ++this.prefixCounter;
                        if (this.prefixCounter == 2) {
                            this.endOfOutput();
                            return;
                        }
                    } else if (this.prefixCounter == 1) {
                        outputStream.write(line.getBytes());
                        ((OutputStream)outputStream).write(10);
                        ((OutputStream)outputStream).flush();
                    }
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

