/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IExecutionLogger;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.Messages;
import org.eclipse.dltk.core.internal.rse.MyHostShellProcessAdapter;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.perfomance.RSEPerfomanceStatistics;
import org.eclipse.dltk.internal.launching.execution.EFSDeployment;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEExecEnvironment
implements IExecutionEnvironment {
    private static final String EXEC_BIN_SH = "exec /bin/sh ";
    private static final String TOKEN_PREFIX = "DLTK_INITIAL_PREFIX_EXECUTION_STRING:";
    private final RSEEnvironment environment;
    private static int counter = -1;
    private static final Map<IHost, Map<String, String>> hostToEnvironment = new HashMap<IHost, Map<String, String>>();
    private static final List<String> UNSAFE_ENV_VARS = Arrays.asList(TextUtils.split((String)"GROUPS;BASH_ARGC;BASH_ARGV;BASH_SOURCE;BASH_LINENO;BASH_VERSINFO;EUID;PPID;SHELLOPTS;UID", (char)';'));

    public RSEExecEnvironment(RSEEnvironment env) {
        this.environment = env;
    }

    public IDeployment createDeployment() {
        block5: {
            if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
                RSEPerfomanceStatistics.inc(4);
            }
            if (!this.getEnvironment().connect()) {
                return null;
            }
            String tmpDir = this.getTempDir();
            if (tmpDir != null) {
                String rootPath = String.valueOf(tmpDir) + this.environment.getSeparator() + this.getTempName("dltk", ".tmp");
                URI rootUri = this.createRemoteURI(this.environment.getHost(), rootPath);
                try {
                    return new EFSDeployment((IEnvironment)this.environment, rootUri);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private URI createRemoteURI(IHost host, String rootPath) {
        return RSEEnvironment.getURIFor(host, rootPath);
    }

    private <SUBSYSTEM extends ISubSystem> SUBSYSTEM getSubSystem(IHost host, Class<SUBSYSTEM> clazz) {
        ISubSystem[] subsys = host.getSubSystems();
        int i = 0;
        while (i < subsys.length) {
            if (clazz.isInstance(subsys[i])) {
                return (SUBSYSTEM)subsys[i];
            }
            ++i;
        }
        return null;
    }

    private String getTempName(String prefix, String suffix) {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return String.valueOf(prefix) + Integer.toString(++counter) + suffix;
    }

    private String getTempDir() {
        IHost host = this.environment.getHost();
        IShellServiceSubSystem system = this.getSubSystem(host, IShellServiceSubSystem.class);
        if (system == null) {
            DLTKRSEPlugin.logWarning(NLS.bind((String)Messages.RSEExecEnvironment_hostNotFound, (Object)host.getName()));
            return null;
        }
        try {
            system.connect((IProgressMonitor)new NullProgressMonitor(), false);
            String tmp = system.getConnectorService().getTempDirectory();
            if (tmp != null && tmp.length() != 0) {
                return tmp;
            }
            return "/tmp";
        }
        catch (Exception e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public Process exec(String[] cmdLine, IPath workingDir, String[] environment) throws CoreException {
        return this.exec(cmdLine, workingDir, environment, null);
    }

    public Process exec(String[] cmdLine, IPath workingDir, String[] environment, IExecutionLogger logger) throws CoreException {
        IHostShell hostShell;
        String command3;
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            RSEPerfomanceStatistics.inc(2);
        }
        long start = RSEPerfomanceStatistics.PERFOMANCE_TRACING ? System.currentTimeMillis() : 0L;
        IHost host = this.environment.getHost();
        IFileServiceSubSystem fileService = this.getSubSystem(host, IFileServiceSubSystem.class);
        if (fileService == null) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(201, NLS.bind((String)Messages.RSEExecEnvironment_NoFileServicerError, (Object)host.getAliasName()), null));
        }
        if (!this.getEnvironment().connect()) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(201, NLS.bind((String)Messages.RSEExecEnvironment_NotConnected, (Object)host.getAliasName()), null));
        }
        String tmpLauncherDir = this.getTempDir();
        String tmpLauncher = "dltk-" + fileService.getUserId() + System.currentTimeMillis() + ".sh";
        String tmpLauncherPath = String.valueOf(tmpLauncherDir) + fileService.getSeparatorChar() + tmpLauncher;
        ArrayList<String> commands = new ArrayList<String>();
        if (workingDir != null) {
            String p = this.environment.convertPathToString(workingDir);
            commands.add("cd " + p);
        } else {
            commands.add("cd /");
        }
        if (environment != null) {
            int i = 0;
            while (i < environment.length) {
                String env = environment[i];
                if (this.isSafeEnvironmentVariable(RSEExecEnvironment.extractName(env))) {
                    commands.add(RSEExecEnvironment.buildExportCommand(env));
                }
                ++i;
            }
        }
        String token = TOKEN_PREFIX + System.currentTimeMillis();
        String echoCmd = "echo \"" + token + "\"";
        commands.add(echoCmd);
        commands.add(this.buildCommand(cmdLine));
        commands.add(echoCmd);
        commands.add("rm -f " + tmpLauncherPath);
        if (logger != null) {
            logger.logLine("launcher=" + tmpLauncherDir + '/' + tmpLauncher);
            for (String command2 : commands) {
                logger.logLine("launcher:" + command2);
            }
            logger.logLine("launcher:END");
        }
        try {
            OutputStream os = fileService.getFileService().getOutputStream(tmpLauncherDir, tmpLauncher, 2, (IProgressMonitor)new NullProgressMonitor());
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os, 4096), fileService.getRemoteEncoding());
                try {
                    for (String command3 : commands) {
                        writer.write(command3);
                        ((Writer)writer).write(10);
                    }
                    ((Writer)writer).flush();
                }
                finally {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.RSEExecEnvironment_LauncherUploadError, (Object)host.getAliasName(), (Object)e.getMessage());
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(301, msg, e));
        }
        IShellServiceSubSystem shell = this.getSubSystem(host, IShellServiceSubSystem.class);
        if (shell == null) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(200, NLS.bind((String)Messages.RSEExecEnvironment_NoShellService, (Object)host.getAliasName()), null));
        }
        try {
            shell.connect((IProgressMonitor)new NullProgressMonitor(), false);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(210, NLS.bind((String)Messages.RSEExecEnvironment_ErrorConnecting, (Object)host.getAliasName(), (Object)e.getMessage()), e));
        }
        if (!shell.isConnected()) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(211, NLS.bind((String)Messages.RSEExecEnvironment_NotConnected, (Object)host.getAliasName()), null));
        }
        IShellService shellService = shell.getShellService();
        command3 = EXEC_BIN_SH + tmpLauncherPath;
        try {
            hostShell = shellService.runCommand("", command3, environment, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(220, NLS.bind((String)Messages.RSEExecEnvironment_ErrorRunningCommand, (Object)host.getAliasName(), (Object)e.getMessage()), e));
        }
        try {
            MyHostShellProcessAdapter myHostShellProcessAdapter = new MyHostShellProcessAdapter(hostShell, token, logger);
            return myHostShellProcessAdapter;
        }
        catch (Exception e) {
            hostShell.writeToShell("\u0003");
            hostShell.exit();
            throw new CoreException((IStatus)RSEExecEnvironment.newStatus(500, NLS.bind((String)Messages.RSEExecEnvironment_ProcessCreateError, (Object)e.getMessage()), e));
        }
        finally {
            if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
                RSEPerfomanceStatistics.inc(9, System.currentTimeMillis() - start);
            }
        }
    }

    public boolean isSafeEnvironmentVariable(String envVarName) {
        return !UNSAFE_ENV_VARS.contains(envVarName);
    }

    private static String buildExportCommand(String envEntry) {
        return String.valueOf(RSEExecEnvironment.toShellArguments(envEntry)) + ";export " + RSEExecEnvironment.extractName(envEntry);
    }

    private static Status newStatus(int code, String msg, Throwable exception) {
        return new Status(4, "org.eclipse.dltk.rse.core", code, msg, exception);
    }

    private static String extractName(String environmentEntry) {
        int pos = environmentEntry.indexOf(61);
        return pos > 0 ? environmentEntry.substring(0, pos) : environmentEntry;
    }

    private static int scanMissingQuote(String cmd) {
        int quote1 = -1;
        int quote2 = -1;
        int i = 0;
        while (i < cmd.length()) {
            char ch = cmd.charAt(i);
            if (ch == '\"' && quote1 == -1) {
                quote2 = quote2 == -1 ? i : -1;
            } else if (ch == '\'' && quote2 == -1) {
                quote1 = quote1 == -1 ? i : -1;
            }
            ++i;
        }
        if (quote1 != -1 || quote2 != -1) {
            if (quote1 == -1) {
                return quote2;
            }
            if (quote2 == -1) {
                return quote1;
            }
            return Math.min(quote1, quote2);
        }
        return -1;
    }

    private static String toShellArguments(String cmd) {
        int quote = RSEExecEnvironment.scanMissingQuote(cmd);
        if (quote != -1) {
            return String.valueOf(RSEExecEnvironment.toShellArguments(cmd.substring(0, quote))) + "\\" + cmd.charAt(quote) + RSEExecEnvironment.toShellArguments(cmd.substring(quote + 1));
        }
        boolean quote1 = false;
        boolean quote2 = false;
        StringBuilder sb = new StringBuilder(cmd.length() * 2);
        int i = 0;
        while (i < cmd.length()) {
            char ch = cmd.charAt(i);
            if (ch == '\"' && !quote1) {
                quote2 = !quote2;
            } else if (ch == '\'' && !quote2) {
                boolean bl = quote1 = !quote1;
            }
            if (ch == ' ' && !quote1 && !quote2) {
                sb.append('\\');
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private String buildCommand(String[] cmdLine) {
        StringBuffer cmd = new StringBuffer();
        int i = 0;
        while (i < cmdLine.length) {
            if (i != 0) {
                cmd.append(" ");
            }
            cmd.append(cmdLine[i]);
            ++i;
        }
        return cmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getEnvironmentVariables(boolean realyNeed) {
        HashMap result;
        long start;
        block15: {
            if (!this.getEnvironment().connect()) {
                return null;
            }
            if (!realyNeed) {
                return new HashMap();
            }
            start = System.currentTimeMillis();
            Map<IHost, Map<String, String>> map = hostToEnvironment;
            synchronized (map) {
                Map<String, String> result2 = hostToEnvironment.get(this.environment.getHost());
                if (result2 != null) {
                    return new HashMap<String, String>(result2);
                }
            }
            result = new HashMap();
            try {
                Process process = this.exec(new String[]{"set"}, (IPath)Path.EMPTY, null);
                if (process == null) break block15;
                final BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Thread t = new Thread(NLS.bind((String)Messages.RSEExecEnvironment_fetchEnvVars, (Object)this.environment.getHost().getName())){

                    public void run() {
                        block3: {
                            try {
                                String line;
                                while ((line = input.readLine()) != null) {
                                    String varValue;
                                    String varName;
                                    int pos = (line = line.trim()).indexOf("=");
                                    if (pos == -1 || !this.isValid(varName = line.substring(0, pos), varValue = line.substring(pos + 1))) continue;
                                    result.put(varName, varValue);
                                }
                            }
                            catch (IOException e) {
                                if (!DLTKCore.DEBUG) break block3;
                                DLTKRSEPlugin.log(e);
                            }
                        }
                    }

                    private boolean isValid(String varName, String varValue) {
                        return !"".equals(varName) && !"_".equals(varName);
                    }
                };
                t.start();
                try {
                    t.join(25000L);
                }
                catch (InterruptedException e) {
                    DLTKRSEPlugin.log(e);
                }
                process.destroy();
            }
            catch (CoreException e) {
                DLTKRSEPlugin.log(e);
            }
        }
        if (!result.isEmpty()) {
            Map<IHost, Map<String, String>> e = hostToEnvironment;
            synchronized (e) {
                hostToEnvironment.put(this.environment.getHost(), Collections.unmodifiableMap(result));
            }
        }
        if (RSEPerfomanceStatistics.PERFOMANCE_TRACING) {
            long end = System.currentTimeMillis();
            RSEPerfomanceStatistics.inc(6);
            RSEPerfomanceStatistics.inc(5, end - start);
        }
        return result;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean isValidExecutableAndEquals(String possibleName, IPath path) {
        if (this.environment.getHost().getSystemType().isWindows()) {
            possibleName = possibleName.toLowerCase();
            String fName = path.removeFileExtension().toString().toLowerCase();
            String ext = path.getFileExtension();
            if (possibleName.equals(fName) && ("exe".equalsIgnoreCase(ext) || "bat".equalsIgnoreCase(ext))) {
                return true;
            }
        } else {
            String fName = path.lastSegment();
            if (fName.equals(possibleName)) {
                return true;
            }
        }
        return false;
    }
}

