/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class AddSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private final StringDialogField fRootDialogField;
    private final SelectionButtonDialogField fAddExclusionPatterns;
    private final SelectionButtonDialogField fRemoveProjectFolder;
    private final SelectionButtonDialogField fIgnoreConflicts;
    private final LinkFields fLinkFields;
    private final BPListElement fNewElement;
    private final List fExistingEntries;
    private final Hashtable fOrginalExlusionFilters;
    private final Hashtable fOrginalInclusionFilters;
    private final Hashtable fOrginalExlusionFiltersCopy;
    private final Hashtable fOrginalInclusionFiltersCopy;
    private final IPath fOrginalPath;
    private final boolean fLinkedMode;
    private BPListElement fOldProjectSourceFolder;
    private List fModifiedElements;
    private List fRemovedElements;
    private final boolean fAllowConflict;
    private final boolean fAllowRemoveProjectFolder;
    private final boolean fAllowAddExclusionPatterns;
    private final boolean fCanCommitConflictingBuildpath;
    private final IContainer fParent;

    public AddSourceFolderWizardPage(BPListElement newElement, List existingEntries, boolean linkedMode, boolean canCommitConflictingBuildpath, boolean allowIgnoreConflicts, boolean allowRemoveProjectFolder, boolean allowAddExclusionPatterns, IContainer parent) {
        super(PAGE_NAME);
        this.fLinkedMode = linkedMode;
        this.fCanCommitConflictingBuildpath = canCommitConflictingBuildpath;
        this.fAllowConflict = allowIgnoreConflicts;
        this.fAllowRemoveProjectFolder = allowRemoveProjectFolder;
        this.fAllowAddExclusionPatterns = allowAddExclusionPatterns;
        this.fParent = parent;
        this.fOrginalExlusionFilters = new Hashtable();
        this.fOrginalInclusionFilters = new Hashtable();
        this.fOrginalExlusionFiltersCopy = new Hashtable();
        this.fOrginalInclusionFiltersCopy = new Hashtable();
        for (BPListElement element : existingEntries) {
            IPath[] inclusions;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                IPath[] save = new IPath[exlusions.length];
                int i = 0;
                while (i < save.length) {
                    save[i] = exlusions[i];
                    ++i;
                }
                this.fOrginalExlusionFiltersCopy.put(element, save);
                this.fOrginalExlusionFilters.put(element, exlusions);
            }
            if ((inclusions = (IPath[])element.getAttribute("inclusion")) == null) continue;
            IPath[] save = new IPath[inclusions.length];
            int i = 0;
            while (i < save.length) {
                save[i] = inclusions[i];
                ++i;
            }
            this.fOrginalInclusionFiltersCopy.put(element, save);
            this.fOrginalInclusionFilters.put(element, inclusions);
        }
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.fOrginalPath = newElement.getPath();
        if (this.fOrginalPath == null) {
            if (linkedMode) {
                this.setDescription(Messages.format(NewWizardMessages.NewFolderDialog_createIn, newElement.getScriptProject().getElementName()));
            } else {
                this.setDescription(Messages.format(NewWizardMessages.AddSourceFolderWizardPage_description, this.fParent.getFullPath().toString()));
            }
        } else {
            this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_edit_description);
        }
        this.fNewElement = newElement;
        this.fExistingEntries = existingEntries;
        this.fModifiedElements = new ArrayList();
        this.fRemovedElements = new ArrayList();
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fRootDialogField = new StringDialogField();
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        if (this.fNewElement.getPath() == null) {
            this.fRootDialogField.setText("");
        } else {
            this.setFolderDialogText(this.fNewElement.getPath());
        }
        this.fRootDialogField.setEnabled(this.fNewElement.getScriptProject() != null);
        int buttonStyle = 32;
        if (this.fAllowConflict && this.fAllowAddExclusionPatterns || this.fAllowConflict && this.fAllowRemoveProjectFolder || this.fAllowAddExclusionPatterns && this.fAllowRemoveProjectFolder) {
            buttonStyle = 16;
        }
        this.fAddExclusionPatterns = new SelectionButtonDialogField(buttonStyle);
        this.fAddExclusionPatterns.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fAddExclusionPatterns.setSelection(!this.fCanCommitConflictingBuildpath && !this.fAllowRemoveProjectFolder);
        this.fRemoveProjectFolder = new SelectionButtonDialogField(buttonStyle);
        this.fRemoveProjectFolder.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_ReplaceExistingSourceFolder_label);
        this.fRemoveProjectFolder.setSelection(!this.fCanCommitConflictingBuildpath && this.fAllowRemoveProjectFolder);
        this.fIgnoreConflicts = new SelectionButtonDialogField(buttonStyle);
        this.fIgnoreConflicts.setLabelText(NewWizardMessages.AddSourceFolderWizardPage_ignoreNestingConflicts);
        this.fIgnoreConflicts.setSelection(this.fCanCommitConflictingBuildpath);
        this.fLinkFields = new LinkFields();
        if (this.fNewElement.getLinkTarget() != null) {
            this.fLinkFields.setLinkTarget(this.fNewElement.getLinkTarget());
        }
        this.fRemoveProjectFolder.setDialogFieldListener(adapter);
        this.fAddExclusionPatterns.setDialogFieldListener(adapter);
        this.fIgnoreConflicts.setDialogFieldListener(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fLinkFields.setDialogFieldListener(adapter);
        this.packRootDialogFieldChanged();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.fLinkedMode) {
            this.fLinkFields.doFillIntoGrid(composite, layout.numColumns);
            this.fRootDialogField.doFillIntoGrid(composite, layout.numColumns - 1);
        } else {
            this.fRootDialogField.doFillIntoGrid(composite, layout.numColumns - 1);
        }
        if (this.fAllowRemoveProjectFolder) {
            this.fRemoveProjectFolder.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowAddExclusionPatterns) {
            this.fAddExclusionPatterns.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowConflict) {
            this.fIgnoreConflicts.doFillIntoGrid(composite, layout.numColumns);
        }
        LayoutUtil.setHorizontalSpan((Control)this.fRootDialogField.getLabelControl(null), layout.numColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.fRootDialogField.getTextControl(null));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support");
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField field) {
        Path initialPath;
        String message;
        String title;
        IFolder folder;
        if (field == this.fRootDialogField && (folder = this.chooseFolder(title = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title, message = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description, (IPath)(initialPath = new Path(this.fRootDialogField.getText())))) != null) {
            this.setFolderDialogText(folder.getFullPath());
        }
    }

    private void setFolderDialogText(IPath path) {
        IPath shortPath = path.removeFirstSegments(1);
        this.fRootDialogField.setText(shortPath.toString());
    }

    protected void packRootDialogFieldChanged() {
        StatusInfo status = this.updateRootStatus();
        this.updateStatus(new IStatus[]{status});
    }

    private StatusInfo updateRootStatus() {
        IStatus linkNameStatus;
        IScriptProject scriptProject = this.fNewElement.getScriptProject();
        IProject project = scriptProject.getProject();
        StatusInfo pathNameStatus = AddSourceFolderWizardPage.validatePathName(this.fRootDialogField.getText(), this.fParent);
        if (!pathNameStatus.isOK()) {
            return pathNameStatus;
        }
        if (this.fLinkedMode && (linkNameStatus = this.validateLinkLocation(this.fRootDialogField.getText())).matches(4)) {
            StatusInfo result = new StatusInfo();
            result.setError(linkNameStatus.getMessage());
            return result;
        }
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath projPath = project.getFullPath();
        IPath path = this.fParent.getFullPath().append(this.fRootDialogField.getText());
        this.restoreBPElements();
        int projectEntryIndex = -1;
        int i = 0;
        while (i < this.fExistingEntries.size()) {
            IBuildpathEntry curr = ((BPListElement)this.fExistingEntries.get(i)).getBuildpathEntry();
            if (curr.getEntryKind() == 3) {
                if (path.equals((Object)curr.getPath()) && this.fExistingEntries.get(i) != this.fNewElement) {
                    result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                    return result;
                }
                if (projPath.equals((Object)curr.getPath())) {
                    projectEntryIndex = i;
                }
            }
            ++i;
        }
        IFolder folder = this.fParent.getFolder((IPath)new Path(this.fRootDialogField.getText()));
        if (folder.exists() && !folder.getFullPath().equals((Object)this.fOrginalPath)) {
            return new StatusInfo(4, Messages.format(NewWizardMessages.NewFolderDialog_folderNameEmpty_alreadyExists, folder.getFullPath().toString()));
        }
        boolean isProjectASourceFolder = projectEntryIndex != -1;
        this.fModifiedElements.clear();
        this.updateFilters(this.fNewElement.getPath(), path);
        this.fNewElement.setPath(path);
        if (this.fLinkedMode) {
            this.fNewElement.setLinkTarget(this.fLinkFields.getLinkTarget());
        }
        this.fRemovedElements.clear();
        HashSet modified = new HashSet();
        boolean isProjectSourceFolderReplaced = false;
        if (this.fAddExclusionPatterns.isSelected()) {
            if (this.fOrginalPath == null) {
                this.addExclusionPatterns(this.fNewElement, this.fExistingEntries, modified);
                this.fModifiedElements.addAll(modified);
                BPListElement.insert(this.fNewElement, this.fExistingEntries);
            }
        } else if (isProjectASourceFolder) {
            if (this.fRemoveProjectFolder.isSelected()) {
                this.fOldProjectSourceFolder = (BPListElement)this.fExistingEntries.get(projectEntryIndex);
                this.fRemovedElements.add(this.fOldProjectSourceFolder);
                this.fExistingEntries.set(projectEntryIndex, this.fNewElement);
                isProjectSourceFolderReplaced = true;
            } else {
                BPListElement.insert(this.fNewElement, this.fExistingEntries);
            }
        } else {
            BPListElement.insert(this.fNewElement, this.fExistingEntries);
        }
        if (!this.fAllowConflict && this.fCanCommitConflictingBuildpath) {
            return new StatusInfo();
        }
        IModelStatus status = BuildpathEntry.validateBuildpath((IScriptProject)scriptProject, (IBuildpathEntry[])BPListElement.convertToBuildpathEntries(this.fExistingEntries));
        if (!status.isOK()) {
            if (this.fCanCommitConflictingBuildpath) {
                result.setInfo(NLS.bind((String)NewWizardMessages.AddSourceFolderWizardPage_conflictWarning, (Object)status.getMessage()));
            } else {
                result.setError(status.getMessage());
            }
            return result;
        }
        if (!modified.isEmpty()) {
            if (modified.size() == 1) {
                BPListElement elem = (BPListElement)modified.toArray()[0];
                IPath changed = elem.getPath().makeRelative();
                IPath excl = this.fNewElement.getPath().makeRelative();
                result.setInfo(Messages.format(NewWizardMessages.AddSourceFolderWizardPage_addSinglePattern, new Object[]{excl, changed}));
            } else {
                result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, String.valueOf(modified.size())));
            }
            return result;
        }
        if (isProjectSourceFolderReplaced) {
            result.setInfo(NewWizardMessages.AddSourceFolderWizardPage_replaceSourceFolderInfo);
            return result;
        }
        return result;
    }

    public void restore() {
        for (BPListElement element : this.fExistingEntries) {
            if (this.fOrginalExlusionFilters.containsKey(element)) {
                element.setAttribute("exclusion", this.fOrginalExlusionFiltersCopy.get(element));
            }
            if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
            element.setAttribute("inclusion", this.fOrginalInclusionFiltersCopy.get(element));
        }
        this.fNewElement.setPath(this.fOrginalPath);
    }

    private void restoreBPElements() {
        if (this.fNewElement.getPath() != null) {
            for (BPListElement element : this.fExistingEntries) {
                if (this.fOrginalExlusionFilters.containsKey(element)) {
                    element.setAttribute("exclusion", this.fOrginalExlusionFilters.get(element));
                }
                if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
                element.setAttribute("inclusion", this.fOrginalInclusionFilters.get(element));
            }
            if (this.fOldProjectSourceFolder != null) {
                this.fExistingEntries.set(this.fExistingEntries.indexOf(this.fNewElement), this.fOldProjectSourceFolder);
                this.fOldProjectSourceFolder = null;
            } else if (this.fExistingEntries.contains(this.fNewElement)) {
                this.fExistingEntries.remove(this.fNewElement);
            }
        }
    }

    private void updateFilters(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            return;
        }
        IPath projPath = this.fNewElement.getScriptProject().getProject().getFullPath();
        if (projPath.isPrefixOf(oldPath)) {
            oldPath = oldPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        if (projPath.isPrefixOf(newPath)) {
            newPath = newPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        for (BPListElement element : this.fExistingEntries) {
            IPath[] inclusion;
            IPath[] exlusions;
            IPath elementPath = element.getPath();
            if (projPath.isPrefixOf(elementPath) && (elementPath = elementPath.removeFirstSegments(projPath.segmentCount())).segmentCount() > 0) {
                elementPath = elementPath.addTrailingSeparator();
            }
            if ((exlusions = (IPath[])element.getAttribute("exclusion")) != null) {
                int i = 0;
                while (i < exlusions.length) {
                    if (elementPath.append(exlusions[i]).equals((Object)oldPath)) {
                        this.fModifiedElements.add(element);
                        exlusions[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusions);
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) == null) continue;
            int i = 0;
            while (i < inclusion.length) {
                if (elementPath.append(inclusion[i]).equals((Object)oldPath)) {
                    this.fModifiedElements.add(element);
                    inclusion[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                }
                ++i;
            }
            element.setAttribute("inclusion", inclusion);
        }
    }

    private IStatus validateLinkLocation(String folderName) {
        IWorkspace workspace = DLTKUIPlugin.getWorkspace();
        IPath path = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        IFolder folder = this.fNewElement.getScriptProject().getProject().getFolder((IPath)new Path(folderName));
        IStatus locationStatus = workspace.validateLinkLocation((IResource)folder, path);
        if (locationStatus.matches(4)) {
            return locationStatus;
        }
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath path1 = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        IPath resolvedPath = pathVariableManager.resolvePath(path1);
        String resolvedLinkTarget = resolvedPath.toOSString();
        path = new Path(resolvedLinkTarget);
        File linkTargetFile = new Path(resolvedLinkTarget).toFile();
        if (linkTargetFile.exists()) {
            if (!linkTargetFile.isDirectory()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
        } else {
            return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
        }
        if (locationStatus.isOK()) {
            return new StatusInfo();
        }
        return new StatusInfo(locationStatus.getSeverity(), locationStatus.getMessage());
    }

    private static StatusInfo validatePathName(String str, IContainer parent) {
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath parentPath = parent.getFullPath();
        if (str.length() == 0) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, parentPath.toString()));
            return result;
        }
        IPath path = parentPath.append(str);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        if (validate.matches(4)) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            return result;
        }
        IResource res = workspaceRoot.findMember(path);
        if (res != null) {
            if (res.getType() != 2) {
                result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                return result;
            }
        } else {
            URI parentLocation = parent.getLocationURI();
            if (parentLocation != null) {
                try {
                    IFileStore store = EFS.getStore((URI)parentLocation).getChild(str);
                    if (store.fetchInfo().exists()) {
                        result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                        return result;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private void addExclusionPatterns(BPListElement newEntry, List existing, Set modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.size()) {
            boolean added;
            BPListElement curr = (BPListElement)existing.get(i);
            IPath currPath = curr.getPath();
            if (curr != newEntry && curr.getEntryKind() == 3 && currPath.isPrefixOf(entryPath) && (added = curr.addToExclusions(entryPath))) {
                modifiedEntries.add(curr);
            }
            ++i;
        }
    }

    public IResource getCorrespondingResource() {
        return this.fParent.getFolder((IPath)new Path(this.fRootDialogField.getText()));
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fNewElement.getScriptProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp){

            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: Add help support here");
                }
                return result;
            }
        };
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    public List getModifiedElements() {
        if (this.fOrginalPath != null && !this.fModifiedElements.contains(this.fNewElement)) {
            this.fModifiedElements.add(this.fNewElement);
        }
        return this.fModifiedElements;
    }

    public List getRemovedElements() {
        return this.fRemovedElements;
    }

    private final class LinkFields
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private StringButtonDialogField fLinkLocation = new StringButtonDialogField(this);
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";
        private RootFieldAdapter fAdapter;
        private SelectionButtonDialogField fVariables;

        public LinkFields() {
            this.fLinkLocation.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.LinkFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            this.fVariables = new SelectionButtonDialogField(8);
            this.fVariables.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_variables_desc);
            this.fVariables.setDialogFieldListener((DialogField field) -> this.handleVariablesButtonPressed());
        }

        public void setDialogFieldListener(RootFieldAdapter adapter) {
            this.fAdapter = adapter;
        }

        private void doFillIntoGrid(Composite parent, int numColumns) {
            this.fLinkLocation.doFillIntoGrid(parent, numColumns);
            LayoutUtil.setHorizontalSpan((Control)this.fLinkLocation.getLabelControl(null), numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            this.fVariables.doFillIntoGrid(parent, 1);
        }

        public IPath getLinkTarget() {
            return Path.fromOSString((String)this.fLinkLocation.getText());
        }

        public void setLinkTarget(IPath path) {
            this.fLinkLocation.setText(path.toOSString());
        }

        @Override
        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(AddSourceFolderWizardPage.this.getShell());
            dialog.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_directory_message);
            String directoryName = this.fLinkLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = DLTKUIPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLinkLocation.setText(selectedDirectory);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(selectedDirectory.substring(selectedDirectory.lastIndexOf(File.separatorChar) + 1));
                DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        private void handleVariablesButtonPressed() {
            String[] variableNames;
            int variableTypes = 2;
            PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(AddSourceFolderWizardPage.this.getShell(), variableTypes);
            if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
                this.fLinkLocation.setText(variableNames[0]);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(variableNames[0]);
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (this.fAdapter != null) {
                this.fAdapter.dialogFieldChanged(this.fLinkLocation);
            }
        }
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            AddSourceFolderWizardPage.this.packRootChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            AddSourceFolderWizardPage.this.packRootDialogFieldChanged();
        }
    }
}

