/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.dltk.javascript.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ModifyParametersAction
implements IEditorActionDelegate {
    private ScriptEditor editor;
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof ITextSelection ? (ITextSelection)selection : null;
        this.checkEnabled(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof ScriptEditor ? (ScriptEditor)targetEditor : null;
        this.checkEnabled(action);
    }

    private void checkEnabled(IAction action) {
        IMethod method = null;
        if (this.selection instanceof IStructuredSelection) {
            method = ModifyParametersAction.getSingleSelectedMethod((IStructuredSelection)this.selection);
        } else if (this.selection instanceof ITextSelection) {
            ITextSelection text = (ITextSelection)this.selection;
            if (!(text instanceof ModelTextSelection) && text.getLength() == 0) {
                action.setEnabled(true);
                return;
            }
            try {
                method = this.getSingleSelectedMethod(text);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        action.setEnabled(this.editor != null && this.selection != null && method != null);
    }

    public void run(IAction action) {
        try {
            if (!ActionUtil.isEditable((ITextEditor)this.editor)) {
                return;
            }
            IMethod method = null;
            if (this.selection instanceof IStructuredSelection) {
                method = ModifyParametersAction.getSingleSelectedMethod((IStructuredSelection)this.selection);
            } else if (this.selection instanceof ITextSelection) {
                method = this.getSingleSelectedMethod((ITextSelection)this.selection);
            }
            if (method != null) {
                this.startChangeSignatureRefactoring(method);
            } else {
                MessageDialog.openInformation((Shell)this.editor.getEditorSite().getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ModifyParametersAction_unavailable);
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        if (selection.getFirstElement() instanceof IMethod) {
            return (IMethod)selection.getFirstElement();
        }
        return null;
    }

    private IMethod getSingleSelectedMethod(ITextSelection selection) throws ModelException {
        IModelElement elementAt;
        IModelElement[] elements = SelectionConverter.codeResolve((IEditorPart)this.editor);
        if (elements.length > 1) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return (IMethod)elements[0];
        }
        ISourceModule sourceModule = SelectionConverter.getInputAsSourceModule((IEditorPart)this.editor);
        if (sourceModule != null && (elementAt = sourceModule.getElementAt(selection.getOffset())) instanceof IMethod) {
            return (IMethod)elementAt;
        }
        return null;
    }

    private void startChangeSignatureRefactoring(IMethod method) throws ModelException {
        try {
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(method);
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
            ChangeSignatureWizard wizard = new ChangeSignatureWizard(processor, (Refactoring)refactoring);
            new RefactoringStarter().activate((Refactoring)refactoring, (RefactoringWizard)wizard, this.editor.getEditorSite().getShell(), wizard.getDefaultPageTitle(), false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)RefactoringMessages.RefactoringStarter_unexpected_exception);
        }
    }
}

