/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.api.packages.ProxyHelper;
import org.eclipse.php.composer.core.model.ModelAccess;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.internal.core.resources.ComposerProject;
import org.osgi.framework.BundleContext;

public class ComposerPlugin
extends Plugin {
    private static ComposerPlugin plugin;
    public static final String ID = "org.eclipse.php.composer.core";
    private static final String DEBUG = "org.eclipse.php.composer.core/debug";

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 4 && event.getResource() instanceof IProject) {
                    ModelAccess.getInstance().getPackageManager().removeProject((IProject)event.getResource());
                }
            }
        };
        workspace.addResourceChangeListener(listener);
        ProxyHelper.acquireProxyService((BundleContext)bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ProxyHelper.releaseProxyService();
        plugin = null;
        super.stop(bundleContext);
    }

    public static ComposerPlugin getDefault() {
        return plugin;
    }

    public static void debug(String message) {
        if (plugin == null) {
            return;
        }
        String debugOption = Platform.getDebugOption((String)DEBUG);
        if (plugin.isDebugging() && Boolean.parseBoolean(debugOption)) {
            plugin.getLog().log((IStatus)new Status(1, ID, message));
        }
    }

    public static void logException(Exception e) {
        Status status = new Status(4, ID, e.getMessage(), (Throwable)e);
        plugin.getLog().log((IStatus)status);
    }

    public IEclipsePreferences getProjectPreferences(IProject project) {
        ProjectScope ps = new ProjectScope(project);
        return ps.getNode(ID);
    }

    public boolean isBuildpathContainerEnabled() {
        return Platform.getPreferencesService().getBoolean(ID, "prefs.composer.buildpath.enable", true, null);
    }

    public IComposerProject getComposerProject(IScriptProject project) {
        if (project == null) {
            return null;
        }
        return new ComposerProject(project);
    }

    public IComposerProject getComposerProject(IProject project) {
        if (project == null) {
            return null;
        }
        return new ComposerProject(project);
    }
}

