/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;

public class TaskEditorOutlineNode {
    public static final String LABEL_COMMENTS = Messages.TaskEditorOutlineNode_Comments;
    public static final String LABEL_DESCRIPTION = Messages.TaskEditorOutlineNode_Description;
    public static final String LABEL_NEW_COMMENT = Messages.TaskEditorOutlineNode_New_Comment;
    public static final String LABEL_ATTACHMENTS = Messages.TaskEditorOutlineNode_Attachments;
    public static final String LABEL_ATTRIBUTES = Messages.TaskEditorOutlineNode_Attributes;
    public static final String LABEL_RELATED_TASKS = Messages.TaskEditorOutlineNode_Related_Tasks;
    private List<TaskEditorOutlineNode> children;
    private final String label;
    private TaskEditorOutlineNode parent;
    private final TaskAttribute taskAttribute;
    private ITaskComment taskComment;
    private ITaskAttachment taskAttachment;
    private TaskRelation taskRelation;
    private TaskRepository taskRepository;

    private static TaskEditorOutlineNode createNode(TaskData taskData, String attributeId, String label) {
        TaskAttribute taskAttribute = taskData.getRoot().getMappedAttribute(attributeId);
        if (taskAttribute != null) {
            if (label == null) {
                label = taskAttribute.getValue();
            }
            return new TaskEditorOutlineNode(label, taskAttribute);
        }
        return null;
    }

    private static TaskEditorOutlineNode createNode(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        if ("comment".equals(type)) {
            ITaskComment taskComment = TasksUiPlugin.getRepositoryModel().createTaskComment(taskAttribute);
            if (taskComment != null) {
                Date creationDate;
                taskAttribute.getTaskData().getAttributeMapper().updateTaskComment(taskComment, taskAttribute);
                StringBuilder sb = new StringBuilder();
                sb.append(taskComment.getNumber());
                sb.append(": ");
                IRepositoryPerson author = taskComment.getAuthor();
                if (author != null) {
                    sb.append(author.toString());
                }
                if ((creationDate = taskComment.getCreationDate()) != null) {
                    sb.append(" (");
                    sb.append(EditorUtil.formatDateTime(creationDate));
                    sb.append(")");
                }
                TaskEditorOutlineNode node = new TaskEditorOutlineNode(sb.toString(), taskAttribute);
                node.setTaskComment(taskComment);
                return node;
            }
        } else if ("attachment".equals(type)) {
            ITaskAttachment taskAttachment = TasksUiPlugin.getRepositoryModel().createTaskAttachment(taskAttribute);
            if (taskAttachment != null) {
                taskAttribute.getTaskData().getAttributeMapper().updateTaskAttachment(taskAttachment, taskAttribute);
                StringBuilder sb = new StringBuilder();
                sb.append(taskAttribute.getTaskData().getAttributeMapper().getValueLabel(taskAttribute));
                sb.append(": ");
                if (AttachmentUtil.isContext(taskAttachment)) {
                    sb.append(Messages.AttachmentTableLabelProvider_Task_Context);
                } else if (taskAttachment.isPatch()) {
                    sb.append(Messages.AttachmentTableLabelProvider_Patch);
                } else {
                    sb.append(taskAttachment.getFileName());
                }
                TaskEditorOutlineNode node = new TaskEditorOutlineNode(sb.toString(), taskAttribute);
                node.setTaskAttachment(taskAttachment);
                return node;
            }
        } else {
            String label = taskAttribute.getTaskData().getAttributeMapper().getLabel(taskAttribute);
            if (label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
            return new TaskEditorOutlineNode(label, taskAttribute);
        }
        return null;
    }

    public static TaskEditorOutlineNode parse(TaskData taskData, boolean includeAttributes) {
        List comments;
        TaskEditorOutlineNode rootNode = TaskEditorOutlineNode.createNode(taskData, "task.common.summary", null);
        if (rootNode == null) {
            rootNode = new TaskEditorOutlineNode(Messages.TaskEditorOutlineNode_Task_ + taskData.getTaskId());
        }
        if (includeAttributes) {
            TaskList taskList = TasksUiPlugin.getTaskList();
            TaskEditorOutlineNode relatedTasksNode = new TaskEditorOutlineNode(LABEL_RELATED_TASKS);
            rootNode.addChild(relatedTasksNode);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(taskData.getConnectorKind());
            Collection relations = connector.getTaskRelations(taskData);
            TaskRepositoryManager manager = TasksUiPlugin.getRepositoryManager();
            TaskRepository taskRepository = manager.getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
            if (relations != null) {
                Iterator iterator = relations.iterator();
                while (iterator.hasNext()) {
                    TaskRelation taskRelation = (TaskRelation)iterator.next();
                    ITask task = taskList.getTask(taskData.getRepositoryUrl(), taskRelation.getTaskId());
                    String label = task != null ? (task.getTaskKey() != null ? NLS.bind((String)Messages.TaskEditorOutlineNode_TaskRelation_Label, (Object[])new Object[]{task.getTaskKey(), task.getSummary()}) : task.getSummary()) : NLS.bind((String)Messages.TaskEditorOutlineNode_TaskRelation_Label, (Object[])new Object[]{taskRelation.getTaskId(), Messages.TaskEditorOutlineNode_unknown_Label});
                    TaskEditorOutlineNode childNode = new TaskEditorOutlineNode(label);
                    childNode.setTaskRelation(taskRelation);
                    childNode.setTaskRepository(taskRepository);
                    relatedTasksNode.addChild(childNode);
                }
            }
            TaskEditorOutlineNode attributesNode = new TaskEditorOutlineNode(LABEL_ATTRIBUTES);
            rootNode.addChild(attributesNode);
            Map attributes = taskData.getRoot().getAttributes();
            for (TaskAttribute attribute : attributes.values()) {
                TaskEditorOutlineNode node;
                if (!"task.common.kind.default".equals(attribute.getMetaData().getKind()) || (node = TaskEditorOutlineNode.createNode(attribute)) == null) continue;
                attributesNode.addChild(node);
            }
        }
        TaskEditorOutlineNode.addNode(rootNode, taskData, "task.common.description", LABEL_DESCRIPTION);
        List attachments = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
        if (attachments.size() > 0) {
            TaskEditorOutlineNode attachmentNode = new TaskEditorOutlineNode(LABEL_ATTACHMENTS);
            rootNode.addChild(attachmentNode);
            for (TaskAttribute attachmentAttribute : attachments) {
                TaskEditorOutlineNode node = TaskEditorOutlineNode.createNode(attachmentAttribute);
                if (node == null) continue;
                attachmentNode.addChild(node);
            }
        }
        if ((comments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment")).size() > 0) {
            TaskEditorOutlineNode commentsNode = new TaskEditorOutlineNode(LABEL_COMMENTS);
            rootNode.addChild(commentsNode);
            for (TaskAttribute commentAttribute : comments) {
                TaskEditorOutlineNode node = TaskEditorOutlineNode.createNode(commentAttribute);
                if (node == null) continue;
                commentsNode.addChild(node);
            }
        }
        TaskEditorOutlineNode.addNode(rootNode, taskData, "task.common.comment.new", LABEL_NEW_COMMENT);
        return rootNode;
    }

    private static TaskEditorOutlineNode addNode(TaskEditorOutlineNode parentNode, TaskData taskData, String attributeId, String label) {
        TaskEditorOutlineNode node = TaskEditorOutlineNode.createNode(taskData, attributeId, label);
        if (node != null) {
            parentNode.addChild(node);
        }
        return node;
    }

    public TaskEditorOutlineNode(String label) {
        this(label, null);
    }

    public TaskEditorOutlineNode(String label, TaskAttribute taskAttribute) {
        this.label = label;
        this.taskAttribute = taskAttribute;
    }

    public void addChild(TaskEditorOutlineNode node) {
        Assert.isNotNull((Object)node);
        if (this.children == null) {
            this.children = new ArrayList<TaskEditorOutlineNode>();
        }
        node.parent = this;
        this.children.add(node);
    }

    public TaskEditorOutlineNode getChild(String label) {
        if (this.children != null) {
            for (TaskEditorOutlineNode child : this.children) {
                if (!child.getLabel().equals(label)) continue;
                return child;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof TaskEditorOutlineNode) {
            TaskEditorOutlineNode node = (TaskEditorOutlineNode)o;
            return this.getLabel().equals(node.getLabel());
        }
        return false;
    }

    public TaskEditorOutlineNode[] getChildren() {
        return this.children == null ? new TaskEditorOutlineNode[]{} : this.children.toArray(new TaskEditorOutlineNode[this.children.size()]);
    }

    public ITaskComment getTaskComment() {
        return this.taskComment;
    }

    public void setTaskComment(ITaskComment taskComment) {
        this.taskComment = taskComment;
    }

    public TaskAttribute getData() {
        return this.taskAttribute;
    }

    public String getLabel() {
        return this.label;
    }

    public TaskEditorOutlineNode getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    public ITaskAttachment getTaskAttachment() {
        return this.taskAttachment;
    }

    public void setTaskAttachment(ITaskAttachment taskAttachment) {
        this.taskAttachment = taskAttachment;
    }

    public TaskRelation getTaskRelation() {
        return this.taskRelation;
    }

    public void setTaskRelation(TaskRelation taskRelation) {
        this.taskRelation = taskRelation;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public void setTaskRepository(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }
}

