/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class XMLFormatterDocumentOld {
    private final TextDocument textDocument;
    private final Range range;
    private final SharedSettings sharedSettings;
    private final Collection<IFormatterParticipant> formatterParticipants;
    private final XMLFormattingOptions.EmptyElements emptyElements;
    private int startOffset;
    private int endOffset;
    private DOMDocument fullDomDocument;
    private DOMDocument rangeDomDocument;
    private XMLBuilder xmlBuilder;
    private int indentLevel;
    private boolean linefeedOnNextWrite;
    private boolean withinDTDContent;

    public XMLFormatterDocumentOld(TextDocument textDocument, Range range, SharedSettings sharedSettings, Collection<IFormatterParticipant> formatterParticipants) {
        this.textDocument = textDocument;
        this.range = range;
        this.sharedSettings = sharedSettings;
        this.formatterParticipants = formatterParticipants;
        this.emptyElements = sharedSettings.getFormattingSettings().getEmptyElements();
        this.linefeedOnNextWrite = false;
    }

    public List<? extends TextEdit> format() throws BadLocationException {
        this.fullDomDocument = DOMParser.getInstance().parse(this.textDocument.getText(), this.textDocument.getUri(), null, false);
        if (this.isRangeFormatting()) {
            this.setupRangeFormatting(this.range);
        } else {
            this.setupFullFormatting(this.range);
        }
        this.indentLevel = this.getStartingIndentLevel();
        this.format(this.rangeDomDocument);
        List<? extends TextEdit> textEdits = this.getFormatTextEdit();
        return textEdits;
    }

    private boolean isRangeFormatting() {
        return this.range != null;
    }

    private void setupRangeFormatting(Range range) throws BadLocationException {
        int startOffset = this.textDocument.offsetAt(range.getStart());
        int endOffset = this.textDocument.offsetAt(range.getEnd());
        Position startPosition = this.textDocument.positionAt(startOffset);
        Position endPosition = this.textDocument.positionAt(endOffset);
        this.enlargePositionToGutters(startPosition, endPosition);
        this.startOffset = this.textDocument.offsetAt(startPosition);
        this.endOffset = this.textDocument.offsetAt(endPosition);
        String fullText = this.textDocument.getText();
        String rangeText = fullText.substring(this.startOffset, this.endOffset);
        this.withinDTDContent = this.fullDomDocument.isWithinInternalDTD(startOffset);
        Object uri = this.textDocument.getUri();
        if (this.withinDTDContent) {
            uri = (String)uri + ".dtd";
        }
        this.rangeDomDocument = DOMParser.getInstance().parse(rangeText, (String)uri, null, false);
        if (this.containsTextWithinStartTag()) {
            this.adjustOffsetToStartTag();
            rangeText = fullText.substring(this.startOffset, this.endOffset);
            this.rangeDomDocument = DOMParser.getInstance().parse(rangeText, (String)uri, null, false);
        }
        this.xmlBuilder = new XMLBuilder(this.sharedSettings, "", this.textDocument.lineDelimiter(startPosition.getLine()), this.formatterParticipants);
    }

    private boolean containsTextWithinStartTag() {
        if (this.rangeDomDocument.getChildren().size() < 1) {
            return false;
        }
        DOMNode firstChild = this.rangeDomDocument.getChild(0);
        if (!firstChild.isText()) {
            return false;
        }
        int tagContentOffset = firstChild.getStart();
        int fullDocOffset = this.getFullOffsetFromRangeOffset(tagContentOffset);
        DOMNode fullNode = this.fullDomDocument.findNodeAt(fullDocOffset);
        if (!fullNode.isElement()) {
            return false;
        }
        return ((DOMElement)fullNode).isInStartTag(fullDocOffset);
    }

    private void adjustOffsetToStartTag() throws BadLocationException {
        int tagContentOffset = this.rangeDomDocument.getChild(0).getStart();
        int fullDocOffset = this.getFullOffsetFromRangeOffset(tagContentOffset);
        DOMNode fullNode = this.fullDomDocument.findNodeAt(fullDocOffset);
        Position nodePosition = this.textDocument.positionAt(fullNode.getStart());
        nodePosition.setCharacter(0);
        this.startOffset = this.textDocument.offsetAt(nodePosition);
    }

    private void setupFullFormatting(Range range) throws BadLocationException {
        this.startOffset = 0;
        this.endOffset = this.textDocument.getText().length();
        this.rangeDomDocument = this.fullDomDocument;
        Position startPosition = this.textDocument.positionAt(this.startOffset);
        this.xmlBuilder = new XMLBuilder(this.sharedSettings, "", this.textDocument.lineDelimiter(startPosition.getLine()), this.formatterParticipants);
    }

    private void enlargePositionToGutters(Position start, Position end) throws BadLocationException {
        start.setCharacter(0);
        if (end.getCharacter() == 0 && end.getLine() > 0) {
            end.setLine(end.getLine() - 1);
        }
        end.setCharacter(this.textDocument.lineText(end.getLine()).length());
    }

    private int getStartingIndentLevel() throws BadLocationException {
        if (this.withinDTDContent) {
            return 1;
        }
        DOMNode startNode = this.fullDomDocument.findNodeAt(this.startOffset);
        if (startNode.isOwnerDocument()) {
            return 0;
        }
        DOMNode startNodeParent = startNode.getParentNode();
        if (startNodeParent.isOwnerDocument()) {
            return 0;
        }
        int startNodeIndentLevel = this.getNodeIndentLevel(startNodeParent) + 1;
        return startNodeIndentLevel;
    }

    private int getNodeIndentLevel(DOMNode node) throws BadLocationException {
        Position nodePosition = this.textDocument.positionAt(node.getStart());
        String textBeforeNode = this.textDocument.lineText(nodePosition.getLine()).substring(0, nodePosition.getCharacter() + 1);
        int spaceOrTab = this.getSpaceOrTabStartOfString(textBeforeNode);
        if (this.sharedSettings.getFormattingSettings().isInsertSpaces()) {
            return spaceOrTab / this.sharedSettings.getFormattingSettings().getTabSize();
        }
        return spaceOrTab;
    }

    private int getSpaceOrTabStartOfString(String string) {
        int spaceOrTab = 0;
        for (int i = 0; i < string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); ++i) {
            ++spaceOrTab;
        }
        return spaceOrTab;
    }

    private DOMElement getFullDocElemFromRangeElem(DOMElement elemFromRangeDoc) {
        int fullOffset = -1;
        if (elemFromRangeDoc.hasStartTag()) {
            fullOffset = this.getFullOffsetFromRangeOffset(elemFromRangeDoc.getStartTagOpenOffset()) + 1;
        } else if (elemFromRangeDoc.hasEndTag()) {
            fullOffset = this.getFullOffsetFromRangeOffset(elemFromRangeDoc.getEndTagOpenOffset()) + 1;
        } else {
            return null;
        }
        DOMElement elemFromFullDoc = (DOMElement)this.fullDomDocument.findNodeAt(fullOffset);
        return elemFromFullDoc;
    }

    private int getFullOffsetFromRangeOffset(int rangeOffset) {
        return rangeOffset + this.startOffset;
    }

    private boolean startTagExistsInRangeDocument(DOMNode node) {
        if (!node.isElement()) {
            return false;
        }
        return ((DOMElement)node).hasStartTag();
    }

    private boolean startTagExistsInFullDocument(DOMNode node) {
        if (!node.isElement()) {
            return false;
        }
        DOMElement elemFromFullDoc = this.getFullDocElemFromRangeElem((DOMElement)node);
        if (elemFromFullDoc == null) {
            return false;
        }
        return elemFromFullDoc.hasStartTag();
    }

    private void format(DOMNode node) throws BadLocationException {
        block9: {
            block7: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        boolean doLineFeed;
                                        if (!(!this.linefeedOnNextWrite || node.isText() && ((DOMText)node).isWhitespace())) {
                                            this.xmlBuilder.linefeed();
                                            this.linefeedOnNextWrite = false;
                                        }
                                        if (node.getNodeType() == 9) break block7;
                                        boolean bl = doLineFeed = !node.getOwnerDocument().isDTD() && (!node.isComment() || !((DOMComment)node).isCommentSameLineEndTag()) && (!node.isText() || !((DOMText)node).isWhitespace() && ((DOMText)node).hasSiblings());
                                        if (this.indentLevel > 0 && doLineFeed) {
                                            if (!node.isChildOfOwnerDocument() || node.getPreviousNonTextSibling() != null) {
                                                this.xmlBuilder.linefeed();
                                            }
                                            if (!this.startTagExistsInRangeDocument(node) && this.startTagExistsInFullDocument(node)) {
                                                DOMElement startNode = this.getFullDocElemFromRangeElem((DOMElement)node);
                                                int currentIndentLevel = this.getNodeIndentLevel(startNode);
                                                this.xmlBuilder.indent(currentIndentLevel);
                                                this.indentLevel = currentIndentLevel;
                                            } else {
                                                this.xmlBuilder.indent(this.indentLevel);
                                            }
                                        }
                                        if (!node.isElement()) break block8;
                                        this.formatElement((DOMElement)node);
                                        break block9;
                                    }
                                    if (!node.isCDATA()) break block10;
                                    this.formatCDATA((DOMCDATASection)node);
                                    break block9;
                                }
                                if (!node.isComment()) break block11;
                                this.formatComment((DOMComment)node);
                                break block9;
                            }
                            if (!node.isProcessingInstruction()) break block12;
                            this.formatProcessingInstruction(node);
                            break block9;
                        }
                        if (!node.isProlog()) break block13;
                        this.formatProlog(node);
                        break block9;
                    }
                    if (!node.isText()) break block14;
                    this.formatText((DOMText)node);
                    break block9;
                }
                if (!node.isDoctype()) break block9;
                this.formatDocumentType((DOMDocumentType)node);
                break block9;
            }
            if (node.hasChildNodes()) {
                for (DOMNode child : node.getChildren()) {
                    this.format(child);
                }
            }
        }
    }

    private void formatProlog(DOMNode node) {
        XMLFormatterDocumentOld.addPrologToXMLBuilder(node, this.xmlBuilder);
        this.linefeedOnNextWrite = true;
    }

    private void formatText(DOMText textNode) {
        String content = textNode.getData();
        if (textNode.equals(this.fullDomDocument.getLastChild())) {
            this.xmlBuilder.addContent(content);
        } else {
            this.xmlBuilder.addContent(content, textNode.isWhitespace(), textNode.hasSiblings(), textNode.getDelimiter());
        }
    }

    private void formatDocumentType(DOMDocumentType documentType) {
        boolean isDTD = documentType.getOwnerDocument().isDTD();
        if (!isDTD) {
            this.xmlBuilder.startDoctype();
            List<DTDDeclParameter> params = documentType.getParameters();
            for (DTDDeclParameter param : params) {
                if (!documentType.isInternalSubset(param)) {
                    this.xmlBuilder.addParameter(param.getParameter());
                    continue;
                }
                this.xmlBuilder.startDoctypeInternalSubset();
                this.xmlBuilder.linefeed();
                XMLFormatterDocumentOld.formatDTD(documentType, this.indentLevel + 1, this.endOffset, this.xmlBuilder);
                this.xmlBuilder.linefeed();
                this.xmlBuilder.endDoctypeInternalSubset();
            }
            if (documentType.isClosed()) {
                this.xmlBuilder.endDoctype();
            }
            this.linefeedOnNextWrite = true;
        } else {
            XMLFormatterDocumentOld.formatDTD(documentType, this.indentLevel, this.endOffset, this.xmlBuilder);
        }
    }

    private void formatProcessingInstruction(DOMNode node) {
        XMLFormatterDocumentOld.addPIToXMLBuilder(node, this.xmlBuilder);
        if (this.indentLevel == 0) {
            this.xmlBuilder.linefeed();
        }
    }

    private void formatComment(DOMComment comment) {
        this.xmlBuilder.startComment(comment);
        this.xmlBuilder.addContentComment(comment.getData());
        if (comment.isClosed()) {
            this.xmlBuilder.endComment();
        }
        if (this.indentLevel == 0) {
            this.linefeedOnNextWrite = true;
        }
    }

    private void formatCDATA(DOMCDATASection cdata) {
        this.xmlBuilder.startCDATA();
        this.xmlBuilder.addContentCDATA(cdata.getData());
        if (cdata.isClosed()) {
            this.xmlBuilder.endCDATA();
        }
    }

    private void formatElement(DOMElement element) throws BadLocationException {
        String tag = element.getTagName();
        if (element.hasEndTag() && !element.hasStartTag()) {
            this.xmlBuilder.endElement(tag, element.isEndTagClosed());
        } else {
            this.xmlBuilder.startElement(tag, false);
            if (element.hasAttributes()) {
                this.formatAttributes(element);
            }
            XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements(element);
            switch (emptyElements) {
                case expand: {
                    this.xmlBuilder.closeStartElement();
                    this.xmlBuilder.endElement(tag, true);
                    break;
                }
                case collapse: {
                    this.formatElementStartTagSelfCloseBracket(element);
                    break;
                }
                default: {
                    if (element.isStartTagClosed()) {
                        this.formatElementStartTagCloseBracket(element);
                    }
                    boolean hasElements = false;
                    if (element.hasChildNodes()) {
                        ++this.indentLevel;
                        for (DOMNode child : element.getChildren()) {
                            hasElements = hasElements || !child.isText();
                            this.format(child);
                        }
                        --this.indentLevel;
                    }
                    if (element.hasEndTag()) {
                        if (hasElements) {
                            this.xmlBuilder.linefeed();
                            this.xmlBuilder.indent(this.indentLevel);
                        }
                        if (element.hasEndTag() && element.getEndTagOpenOffset() <= this.endOffset) {
                            this.xmlBuilder.endElement(tag, element.isEndTagClosed());
                            break;
                        }
                        this.formatElementStartTagSelfCloseBracket(element);
                        break;
                    }
                    if (!element.isSelfClosed()) break;
                    this.formatElementStartTagSelfCloseBracket(element);
                }
            }
        }
    }

    private void formatElementStartTagCloseBracket(DOMElement element) throws BadLocationException {
        if (this.sharedSettings.getFormattingSettings().isPreserveAttributeLineBreaks() && element.hasAttributes() && !this.isSameLine(this.getLastAttribute(element).getEnd(), element.getStartTagCloseOffset())) {
            this.xmlBuilder.linefeed();
            this.xmlBuilder.indent(this.indentLevel);
        }
        this.xmlBuilder.closeStartElement();
    }

    private void formatElementStartTagSelfCloseBracket(DOMElement element) throws BadLocationException {
        if (this.sharedSettings.getFormattingSettings().isPreserveAttributeLineBreaks() && element.hasAttributes()) {
            int elementEndOffset = element.getEnd();
            if (element.isStartTagClosed()) {
                elementEndOffset = element.getStartTagCloseOffset();
            }
            if (!this.isSameLine(this.getLastAttribute(element).getEnd(), elementEndOffset)) {
                this.xmlBuilder.linefeed();
                this.xmlBuilder.indent(this.indentLevel);
            }
        }
        this.xmlBuilder.selfCloseElement();
    }

    private void formatAttributes(DOMElement element) throws BadLocationException {
        List<DOMAttr> attributes = element.getAttributeNodes();
        boolean isSingleAttribute = this.hasSingleAttributeInFullDoc(element);
        int prevOffset = element.getStart();
        for (DOMAttr attr : attributes) {
            this.formatAttribute(attr, isSingleAttribute, prevOffset);
            prevOffset = attr.getEnd();
        }
        if (this.sharedSettings.getFormattingSettings().getClosingBracketNewLine() && this.sharedSettings.getFormattingSettings().getSplitAttributes() == XMLFormattingOptions.SplitAttributes.splitNewLine && !isSingleAttribute) {
            this.xmlBuilder.linefeed();
            int totalIndent = this.indentLevel + this.sharedSettings.getFormattingSettings().getSplitAttributesIndentSize();
            this.xmlBuilder.indent(totalIndent);
        }
    }

    private void formatAttribute(DOMAttr attr, boolean isSingleAttribute, int prevOffset) throws BadLocationException {
        if (this.sharedSettings.getFormattingSettings().isPreserveAttributeLineBreaks() && !this.isSameLine(prevOffset, attr.getStart())) {
            this.xmlBuilder.linefeed();
            this.xmlBuilder.indent(this.indentLevel + 1);
            this.xmlBuilder.addSingleAttribute(attr, false, false);
        } else if (isSingleAttribute) {
            this.xmlBuilder.addSingleAttribute(attr);
        } else {
            this.xmlBuilder.addAttribute(attr, this.indentLevel);
        }
    }

    private boolean isSameLine(int first, int second) throws BadLocationException {
        if (this.isRangeFormatting()) {
            first = this.getFullOffsetFromRangeOffset(first);
            second = this.getFullOffsetFromRangeOffset(second);
        }
        return this.getLineNumber(first) == this.getLineNumber(second);
    }

    private int getLineNumber(int offset) throws BadLocationException {
        return this.textDocument.positionAt(offset).getLine();
    }

    private DOMAttr getLastAttribute(DOMElement element) {
        if (!element.hasAttributes()) {
            return null;
        }
        List<DOMAttr> attributes = element.getAttributeNodes();
        return attributes.get(attributes.size() - 1);
    }

    private boolean hasSingleAttributeInFullDoc(DOMElement element) {
        DOMElement fullElement = this.getFullDocElemFromRangeElem(element);
        return fullElement.getAttributeNodes().size() == 1;
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements(DOMElement element) {
        if (this.emptyElements != XMLFormattingOptions.EmptyElements.ignore && element.isClosed() && element.isEmpty()) {
            switch (this.emptyElements) {
                case expand: 
                case collapse: {
                    if (this.sharedSettings.getFormattingSettings().isPreserveEmptyContent() && element.hasChildNodes()) {
                        return XMLFormattingOptions.EmptyElements.ignore;
                    }
                    return this.emptyElements;
                }
            }
            return this.emptyElements;
        }
        return XMLFormattingOptions.EmptyElements.ignore;
    }

    private static boolean formatDTD(DOMDocumentType doctype, int level, int end, XMLBuilder xmlBuilder) {
        DOMNode previous = null;
        for (DOMNode node : doctype.getChildren()) {
            if (previous != null) {
                xmlBuilder.linefeed();
            }
            xmlBuilder.indent(level);
            if (node.isText()) {
                xmlBuilder.addContent(((DOMText)node).getData().trim());
            } else if (node.isComment()) {
                DOMComment comment = (DOMComment)node;
                xmlBuilder.startComment(comment);
                xmlBuilder.addContentComment(comment.getData());
                xmlBuilder.endComment();
            } else if (node.isProcessingInstruction()) {
                XMLFormatterDocumentOld.addPIToXMLBuilder(node, xmlBuilder);
            } else if (node.isProlog()) {
                XMLFormatterDocumentOld.addPrologToXMLBuilder(node, xmlBuilder);
            } else {
                boolean setEndBracketOnNewLine = false;
                DTDDeclNode decl = (DTDDeclNode)node;
                xmlBuilder.addDeclTagStart(decl);
                if (decl.isDTDAttListDecl()) {
                    DTDAttlistDecl attlist = (DTDAttlistDecl)decl;
                    List<DTDAttlistDecl> internalDecls = attlist.getInternalChildren();
                    if (internalDecls == null) {
                        for (DTDDeclParameter param : decl.getParameters()) {
                            xmlBuilder.addParameter(param.getParameter());
                        }
                    } else {
                        DTDDeclParameter param;
                        boolean multipleInternalAttlistDecls = false;
                        List<DTDDeclParameter> params = attlist.getParameters();
                        for (int i = 0; i < params.size(); ++i) {
                            param = params.get(i);
                            if (attlist.getNameParameter().equals(param)) {
                                xmlBuilder.addParameter(param.getParameter());
                                if (attlist.getParameters().size() <= 1) continue;
                                xmlBuilder.linefeed();
                                xmlBuilder.indent(level + 1);
                                setEndBracketOnNewLine = true;
                                multipleInternalAttlistDecls = true;
                                continue;
                            }
                            if (multipleInternalAttlistDecls && i == 1) {
                                xmlBuilder.addUnindentedParameter(param.getParameter());
                                continue;
                            }
                            xmlBuilder.addParameter(param.getParameter());
                        }
                        for (DTDAttlistDecl attlistDecl : internalDecls) {
                            xmlBuilder.linefeed();
                            xmlBuilder.indent(level + 1);
                            params = attlistDecl.getParameters();
                            for (int i = 0; i < params.size(); ++i) {
                                param = params.get(i);
                                if (i == 0) {
                                    xmlBuilder.addUnindentedParameter(param.getParameter());
                                    continue;
                                }
                                xmlBuilder.addParameter(param.getParameter());
                            }
                        }
                    }
                } else {
                    for (DTDDeclParameter param : decl.getParameters()) {
                        xmlBuilder.addParameter(param.getParameter());
                    }
                }
                if (setEndBracketOnNewLine) {
                    xmlBuilder.linefeed();
                    xmlBuilder.indent(level);
                }
                if (decl.isClosed()) {
                    xmlBuilder.closeStartElement();
                }
            }
            previous = node;
        }
        return true;
    }

    private List<? extends TextEdit> getFormatTextEdit() throws BadLocationException {
        Position startPosition = this.textDocument.positionAt(this.startOffset);
        Position endPosition = this.textDocument.positionAt(this.endOffset);
        Range r = new Range(startPosition, endPosition);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        if (this.endOffset == this.textDocument.getText().length()) {
            if (this.sharedSettings.getFormattingSettings().isTrimFinalNewlines()) {
                this.xmlBuilder.trimFinalNewlines();
            }
            if (this.sharedSettings.getFormattingSettings().isInsertFinalNewline() && !this.xmlBuilder.isLastLineEmptyOrWhitespace()) {
                this.xmlBuilder.linefeed();
            }
        }
        edits.add(new TextEdit(r, this.xmlBuilder.toString()));
        return edits;
    }

    private static void addPIToXMLBuilder(DOMNode node, XMLBuilder xml) {
        DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)node;
        xml.startPrologOrPI(processingInstruction.getTarget());
        String content = processingInstruction.getData();
        if (content.length() > 0) {
            xml.addContentPI(content);
        } else {
            xml.addContent(" ");
        }
        xml.endPrologOrPI();
    }

    private static void addPrologToXMLBuilder(DOMNode node, XMLBuilder xml) {
        DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)node;
        xml.startPrologOrPI(processingInstruction.getTarget());
        if (node.hasAttributes()) {
            XMLFormatterDocumentOld.addPrologAttributes(node, xml);
        }
        xml.endPrologOrPI();
    }

    private static void addPrologAttributes(DOMNode node, XMLBuilder xmlBuilder) {
        List<DOMAttr> attrs = node.getAttributeNodes();
        if (attrs == null) {
            return;
        }
        for (DOMAttr attr : attrs) {
            xmlBuilder.addPrologAttribute(attr);
        }
    }
}

