/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class WorkbenchContentProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener {
    private Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            IWorkspace workspace = null;
            Object obj = this.viewer.getInput();
            if (obj instanceof IWorkspace) {
                workspace = (IWorkspace)obj;
            } else if (obj instanceof IContainer) {
                workspace = ((IContainer)obj).getWorkspace();
            }
            if (workspace != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
        super.dispose();
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        super.inputChanged(newViewer, oldInput, newInput);
        this.viewer = newViewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(() -> {
                Control ctrl1 = this.viewer.getControl();
                if (ctrl1 == null || ctrl1.isDisposed()) {
                    return;
                }
                this.runUpdates(runnables);
            });
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        Iterator<Runnable> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            runnableIterator.next().run();
        }
    }

    private void processDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        IResourceDelta[] affectedChildren;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren(4);
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta affectedChild = iResourceDeltaArray[n2];
            if ((affectedChild.getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++n2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x4000) != 0) {
            if (resource.isAccessible()) {
                runnables.add(this.getUpdateRunnable(resource));
            } else {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
        }
        if ((changeFlags & 0x98000) != 0) {
            runnables.add(this.getUpdateRunnable(resource));
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        IResourceDelta[] iResourceDeltaArray2 = affectedChildren;
        int n3 = affectedChildren.length;
        n = 0;
        while (n < n3) {
            IResourceDelta affectedChild = iResourceDeltaArray2[n];
            this.processDelta(affectedChild, runnables);
            ++n;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = () -> {
            Viewer viewer = this.viewer;
            if (viewer instanceof AbstractTreeViewer) {
                AbstractTreeViewer treeViewer = (AbstractTreeViewer)viewer;
                if (hasRename) {
                    treeViewer.getControl().setRedraw(false);
                }
                try {
                    if (addedObjects.length > 0) {
                        treeViewer.add((Object)resource, addedObjects);
                    }
                    if (removedObjects.length <= 0) return;
                    treeViewer.remove(removedObjects);
                    return;
                }
                finally {
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(true);
                    }
                }
            } else {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
            }
        };
        runnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(IResource resource) {
        return () -> ((StructuredViewer)this.viewer).refresh((Object)resource);
    }

    private Runnable getUpdateRunnable(IResource resource) {
        return () -> ((StructuredViewer)this.viewer).update((Object)resource, null);
    }
}

