/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemExpansionChangeCommand;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.AbstractDTreeItemRunnableWithProgress;

public class CollapseDTreeItemRunnableWithProgress
extends AbstractDTreeItemRunnableWithProgress {
    private final List<DTreeItem> dTreeItems;

    public CollapseDTreeItemRunnableWithProgress(Session session, DTreeItem dTreeItem) {
        super(session, dTreeItem);
        this.dTreeItems = List.of(dTreeItem);
    }

    public CollapseDTreeItemRunnableWithProgress(Session session, List<DTreeItem> dTreeItemsToColllapse) {
        super(session, true, dTreeItemsToColllapse == null ? 0 : dTreeItemsToColllapse.size());
        this.dTreeItems = dTreeItemsToColllapse;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            String commandLabel = AbstractDTreeItemRunnableWithProgress.getCommandLabel(this.dTreeItems.get(this.dTreeItems.size() - 1), Messages.CollapseDTreeItemRunnableWithProgress_collapseTreeItem, Messages.CollapseDTreeItemRunnableWithProgress_collapseAllTreeItems, this.isCollapseOrExpandAll());
            monitor.beginTask(commandLabel, 1);
            CompoundCommand collapseDTreeItemsCmd = new CompoundCommand(commandLabel);
            for (DTreeItem dTreeItem : this.dTreeItems) {
                collapseDTreeItemsCmd.append((Command)new DTreeItemExpansionChangeCommand(this.getGlobalContext(), this.getDomain(), dTreeItem, monitor, false));
            }
            this.getCommandStack().execute((Command)collapseDTreeItemsCmd);
        }
        finally {
            monitor.done();
        }
    }
}

