/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.io.IORuntimeException;

public class LoadRevisionsRequest
extends CDOClientRequest<List<RevisionInfo>> {
    private final List<RevisionInfo> infos;
    private final CDOBranchPoint branchPoint;
    private final int referenceChunk;
    private final int prefetchDepth;
    private final boolean prefetchLockStates;
    private Map<CDORevisionKey, CDORevision> rememberedRevisions;

    public LoadRevisionsRequest(CDOClientProtocol protocol, List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth, boolean prefetchLockStates) {
        super(protocol, (short)7);
        this.infos = infos;
        this.branchPoint = branchPoint;
        this.referenceChunk = referenceChunk;
        this.prefetchDepth = prefetchDepth;
        this.prefetchLockStates = prefetchLockStates;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeCDOBranchPoint(this.branchPoint);
        out.writeXInt(this.referenceChunk);
        out.writeBoolean(this.prefetchLockStates);
        InternalCDOSession session = this.getSession();
        int size = this.infos.size();
        if (this.prefetchDepth == 0) {
            out.writeXInt(size);
        } else {
            out.writeXInt(-size);
            out.writeXInt(this.prefetchDepth);
            InternalCDORevisionCache cache = session.getRevisionManager().getCache();
            boolean branching = session.getRepositoryInfo().isSupportingBranches();
            this.rememberedRevisions = new HashMap<CDORevisionKey, CDORevision>();
            int maxRevisionKeys = session.options().getPrefetchSendMaxRevisionKeys();
            if (maxRevisionKeys != 0) {
                try {
                    int[] revisionKeys = new int[1];
                    cache.forEachValidRevision(this.branchPoint, branching, r -> {
                        nArray[0] = revisionKeys[0] + 1;
                        if (nArray[0] > maxRevisionKeys) {
                            throw new Worker.Terminate();
                        }
                        try {
                            CDORevisionKey key = CDORevisionUtil.copyRevisionKey((CDORevisionKey)r);
                            this.rememberedRevisions.put(key, (CDORevision)r);
                            out.writeCDORevisionKey(key);
                        }
                        catch (IOException ex) {
                            throw new IORuntimeException((Throwable)ex);
                        }
                    });
                }
                catch (Worker.Terminate revisionKeys) {
                }
                catch (IORuntimeException ex) {
                    ex.rethrow();
                }
            }
            out.writeCDORevisionKey(null);
        }
        ArrayList<CDOID> ids = new ArrayList<CDOID>(size);
        for (RevisionInfo info : this.infos) {
            info.write(out);
            ids.add(info.getID());
        }
        CDOFetchRuleManager ruleManager = session.getFetchRuleManager();
        List fetchRules = ruleManager.getFetchRules(ids);
        int fetchRulesCount = ObjectUtil.size((Collection)fetchRules);
        out.writeXInt(fetchRulesCount);
        if (fetchRulesCount > 0) {
            CDOCollectionLoadingPolicy collectionLoadingPolicy = ruleManager.getCollectionLoadingPolicy();
            out.writeXInt(collectionLoadingPolicy != null ? collectionLoadingPolicy.getInitialChunkSize() : -1);
            CDOID contextID = ruleManager.getContext();
            out.writeCDOID(contextID);
            for (CDOFetchRule fetchRule : fetchRules) {
                fetchRule.write(out);
            }
        }
    }

    @Override
    protected List<RevisionInfo> confirming(CDODataInput in) throws IOException {
        RememberedRevisionInfo info;
        CDORevisionKey key;
        for (RevisionInfo info2 : this.infos) {
            info2.readResult(in);
        }
        ArrayList<RevisionInfo> additionalInfos = null;
        CDOBranch requestedBranch = this.branchPoint.getBranch();
        while ((key = in.readCDORevisionKey()) != null) {
            if (additionalInfos == null) {
                additionalInfos = new ArrayList<RevisionInfo>();
            }
            CDORevision revision = this.rememberedRevisions.get(key);
            info = new RememberedRevisionInfo(revision);
            info.setResult((InternalCDORevision)revision);
            if (revision.getBranch() != requestedBranch) {
                info.setSynthetic((SyntheticCDORevision)new PointerCDORevision(revision.getEClass(), revision.getID(), requestedBranch, in.readXLong(), (CDOBranchVersion)revision));
            }
            additionalInfos.add((RevisionInfo)info);
        }
        int additionalSize = in.readXInt();
        if (additionalSize != 0) {
            if (additionalInfos == null) {
                additionalInfos = new ArrayList(additionalSize);
            }
            int i = 0;
            while (i < additionalSize) {
                info = RevisionInfo.read((CDODataInput)in, (CDOBranchPoint)this.branchPoint);
                info.readResult(in);
                additionalInfos.add((RevisionInfo)info);
                ++i;
            }
        }
        InternalCDOSession session = this.getSession();
        CDOClientProtocol.readAndCacheLockStates(in, session, requestedBranch);
        if (this.rememberedRevisions != null) {
            this.rememberedRevisions.clear();
        }
        return additionalInfos;
    }

    protected String getAdditionalInfo() {
        return MessageFormat.format("infos={0}, branchPoint={1}, referenceChunk={2}, prefetchDepth={3}, prefetchLockStates={4}", this.infos, this.branchPoint, this.referenceChunk, this.prefetchDepth, this.prefetchLockStates);
    }

    private static final class RememberedRevisionInfo
    extends RevisionInfo.Available {
        public RememberedRevisionInfo(CDORevision revision) {
            super(revision.getID(), null, (CDOBranchVersion)revision);
        }

        public RevisionInfo.Type getType() {
            return null;
        }
    }
}

