/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.importer.rose.parser.RoseLoader;
import org.eclipse.emf.importer.rose.parser.RoseToken;

public class RoseLexer {
    protected RoseLoader roseLoader;
    protected List<RoseToken> tokens = new ArrayList<RoseToken>();
    protected int currentElement = 0;
    protected boolean isList = false;
    protected int lineCounter = 0;

    public RoseLexer(RoseLoader roseLoader) {
        this.roseLoader = roseLoader;
    }

    protected void getNextBlock() {
        RoseToken roseToken = null;
        if (this.tokens.size() > this.currentElement) {
            roseToken = this.tokens.get(this.currentElement);
        }
        this.tokens.clear();
        if (roseToken != null) {
            this.tokens.add(roseToken);
        }
        this.currentElement = 0;
        System.gc();
        this.readLines();
    }

    public RoseToken getNext() {
        if (this.currentElement >= this.tokens.size()) {
            this.getNextBlock();
        }
        if (this.currentElement < this.tokens.size()) {
            RoseToken roseToken = this.tokens.get(this.currentElement);
            ++this.currentElement;
            return roseToken;
        }
        return null;
    }

    public RoseToken peekNext() {
        if (this.currentElement >= this.tokens.size()) {
            this.getNextBlock();
        }
        if (this.currentElement < this.tokens.size()) {
            return this.tokens.get(this.currentElement);
        }
        return null;
    }

    public void printNeighbors() {
        int count = 100;
        if (this.currentElement < 100) {
            count = this.currentElement;
        }
        int i = this.currentElement - count;
        while (i <= this.currentElement) {
            RoseToken tok = this.tokens.get(i);
            System.out.println(tok.getToken());
            ++i;
        }
    }

    public void readLines() {
        int k = 0;
        while (k < 1000) {
            String currentLine = this.roseLoader.readLine();
            if (currentLine == null) {
                return;
            }
            ++this.lineCounter;
            if (currentLine.length() == 0) {
                --k;
            } else if (currentLine.charAt(0) == '|') {
                RoseToken roseToken = new RoseToken(4, "");
                roseToken.lineNum = this.lineCounter;
                this.tokens.add(roseToken);
                currentLine = currentLine.substring(1);
                roseToken = new RoseToken(6, currentLine);
                roseToken.lineNum = this.lineCounter;
                this.tokens.add(roseToken);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(currentLine);
                int i = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String temp;
                    String tok = stringTokenizer.nextToken();
                    if (tok.equals("#")) break;
                    currentLine = currentLine.substring(currentLine.indexOf(tok));
                    if (tok.equals("(object")) {
                        this.isList = false;
                        RoseToken roseToken = new RoseToken(2, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        roseToken = new RoseToken(0, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        currentLine = currentLine.substring(7).trim();
                        this.processToTheEnd(currentLine, this.lineCounter);
                        break;
                    }
                    if (tok.equals("(list")) {
                        this.isList = true;
                        RoseToken roseToken = new RoseToken(2, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        roseToken = new RoseToken(1, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        currentLine = currentLine.substring(5).trim();
                        this.processToTheEnd(currentLine, this.lineCounter);
                        break;
                    }
                    if (tok.equals("(value")) {
                        this.isList = false;
                        RoseToken roseToken = new RoseToken(2, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        roseToken = new RoseToken(7, "");
                        roseToken.lineNum = this.lineCounter;
                        this.tokens.add(roseToken);
                        currentLine = currentLine.substring(6).trim();
                        this.processValueToTheEnd(currentLine, this.lineCounter);
                        break;
                    }
                    if (i == 0 && tok.charAt(0) == ')') {
                        int rightParenNum = 0;
                        temp = tok;
                        while (temp.length() > 0 && temp.charAt(temp.length() - 1) == ')') {
                            ++rightParenNum;
                            temp = temp.substring(0, temp.length() - 1);
                        }
                        int j = 0;
                        while (j < rightParenNum) {
                            this.isList = false;
                            RoseToken roseToken = new RoseToken(3, "");
                            roseToken.lineNum = this.lineCounter;
                            this.tokens.add(roseToken);
                            ++j;
                        }
                        break;
                    }
                    if (i == 0) {
                        if (this.isList) {
                            int rightParenNum = 0;
                            temp = currentLine.trim();
                            while (temp.charAt(temp.length() - 1) == ')') {
                                ++rightParenNum;
                                temp = temp.substring(0, temp.length() - 1);
                            }
                            if (currentLine.charAt(0) == '(') {
                                --rightParenNum;
                                temp = String.valueOf(temp) + ")";
                            }
                            RoseToken roseToken = new RoseToken(6, temp);
                            roseToken.lineNum = this.lineCounter;
                            this.tokens.add(roseToken);
                            int j = 0;
                            while (j < rightParenNum) {
                                this.isList = false;
                                roseToken = new RoseToken(3, "");
                                roseToken.lineNum = this.lineCounter;
                                this.tokens.add(roseToken);
                                ++j;
                            }
                            break;
                        }
                    } else {
                        this.isList = false;
                        currentLine = currentLine.trim();
                        this.processToTheEnd(currentLine, this.lineCounter);
                        break;
                    }
                    this.isList = false;
                    RoseToken roseToken = new RoseToken(5, tok);
                    roseToken.lineNum = this.lineCounter;
                    this.tokens.add(roseToken);
                    ++i;
                }
            }
            ++k;
        }
    }

    protected void processToTheEnd(String temp, int lineCounter) {
        if (temp.length() == 0) {
            RoseToken roseToken = new RoseToken(6, temp);
            roseToken.lineNum = lineCounter;
            this.tokens.add(roseToken);
            return;
        }
        int indFirst = temp.indexOf("\"");
        int indLast = temp.lastIndexOf("\"");
        if (indFirst != -1 && indFirst == indLast) {
            String currentLine = this.roseLoader.readLine();
            temp = String.valueOf(temp) + currentLine;
            while (currentLine.indexOf("\"") == -1) {
                currentLine = this.roseLoader.readLine();
                temp = String.valueOf(temp) + currentLine;
            }
        }
        int rightParenNum = 0;
        while (temp.charAt(temp.length() - 1) == ')') {
            ++rightParenNum;
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.charAt(0) == '(') {
            --rightParenNum;
            temp = String.valueOf(temp) + ")";
        }
        RoseToken roseToken = new RoseToken(6, temp);
        roseToken.lineNum = lineCounter;
        this.tokens.add(roseToken);
        int i = 0;
        while (i < rightParenNum) {
            this.isList = false;
            roseToken = new RoseToken(3, "");
            roseToken.lineNum = lineCounter;
            this.tokens.add(roseToken);
            ++i;
        }
    }

    protected void processValueToTheEnd(String temp, int lineCounter) {
        if (temp.length() == 0) {
            RoseToken roseToken = new RoseToken(6, temp);
            roseToken.lineNum = lineCounter;
            this.tokens.add(roseToken);
            return;
        }
        int rightParenNum = 0;
        while (temp.charAt(temp.length() - 1) == ')') {
            ++rightParenNum;
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.charAt(0) == '(') {
            --rightParenNum;
            temp = String.valueOf(temp) + ")";
        }
        String firstWord = temp;
        String restOfString = "";
        int indexOfSpace = temp.indexOf(" ");
        if (indexOfSpace == -1) {
            indexOfSpace = temp.indexOf("\t");
        }
        if (indexOfSpace != -1) {
            firstWord = temp.substring(0, indexOfSpace);
            restOfString = temp.substring(indexOfSpace).trim();
        }
        RoseToken roseToken = new RoseToken(6, firstWord);
        roseToken.lineNum = lineCounter;
        this.tokens.add(roseToken);
        if (restOfString.length() > 0) {
            roseToken = new RoseToken(6, restOfString);
            roseToken.lineNum = lineCounter;
            this.tokens.add(roseToken);
        }
        int i = 0;
        while (i < rightParenNum) {
            this.isList = false;
            roseToken = new RoseToken(3, "");
            roseToken.lineNum = lineCounter;
            this.tokens.add(roseToken);
            ++i;
        }
    }
}

