/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.widgets.ImageBasedFrame;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSRenderingUtils {
    private static final String DRAG_HANDLE = "org.eclipse.e4.ui.workbench.swt.DRAG_HANDLE";
    private static final String DRAG_HANDLE_ROTATED = "org.eclipse.e4.ui.workbench.swt.DRAG_HANDLE-ROTATED";
    private static final String FRAME_IMAGE_PROP = "frame-image";
    private static final String FRAME_IMAGE_ROTATE_PROP = "frame-image-rotated";
    private static final String HANDLE_IMAGE_PROP = "handle-image";
    private static final String HANDLE_IMAGE_ROTATE_PROP = "handle-image-rotated";
    private final Map<Image, Image> rotatedImageMap = new HashMap<Image, Image>();

    public Control frameMeIfPossible(Control toFrame, String classId, boolean vertical, boolean draggable) {
        Image handleImage;
        Integer[] frameInts = new Integer[4];
        Image frameImage = this.createImage(toFrame, classId, FRAME_IMAGE_PROP, frameInts);
        if (vertical && frameImage != null) {
            Image frameImageRotated = this.createImage(toFrame, classId, FRAME_IMAGE_ROTATE_PROP, frameInts);
            if (frameImageRotated != null) {
                frameImage = frameImageRotated;
                if (frameInts != null) {
                    int tmp = frameInts[0];
                    frameInts[0] = frameInts[2];
                    frameInts[2] = tmp;
                    tmp = frameInts[1];
                    frameInts[1] = frameInts[3];
                    frameInts[3] = tmp;
                }
            } else {
                frameImage = this.rotateImage(toFrame.getDisplay(), frameImage, frameInts);
            }
        }
        if ((handleImage = this.createImage(toFrame, classId, HANDLE_IMAGE_PROP, null)) == null && draggable && (handleImage = JFaceResources.getImage((String)DRAG_HANDLE)) == null) {
            this.initDragHandleResource();
            handleImage = JFaceResources.getImage((String)DRAG_HANDLE);
        }
        if (vertical && handleImage != null) {
            Image handleImageRotated = this.createImage(toFrame, classId, HANDLE_IMAGE_ROTATE_PROP, null);
            if (handleImageRotated != null) {
                handleImage = handleImageRotated;
            } else {
                handleImage = JFaceResources.getImage((String)DRAG_HANDLE_ROTATED);
                if (handleImage == null) {
                    this.initDragHandleResource();
                    handleImage = JFaceResources.getImage((String)DRAG_HANDLE_ROTATED);
                }
            }
        }
        if (frameImage != null) {
            ImageBasedFrame frame = new ImageBasedFrame(toFrame.getParent(), toFrame, vertical, draggable);
            frame.setImages(frameImage, frameInts, handleImage);
            this.addFrameImageDisposedListener(frame, toFrame, classId, vertical);
            return frame;
        }
        if (handleImage != null) {
            ImageBasedFrame frame = new ImageBasedFrame(toFrame.getParent(), toFrame, vertical, draggable);
            frame.setImages(null, null, handleImage);
            this.addHandleImageDisposedListener(frame, toFrame, classId, vertical);
            return frame;
        }
        return toFrame;
    }

    private void initDragHandleResource() {
        ImageDescriptor desc_rotated;
        IPath path;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = IPath.fromOSString((String)"$ws$/images/dragHandle.svg")), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        if (desc != null) {
            JFaceResources.getImageRegistry().put(DRAG_HANDLE, desc);
        }
        if ((desc_rotated = ImageDescriptor.createFromURL((URL)(url = FileLocator.find((Bundle)bundle, (IPath)(path = IPath.fromOSString((String)"$ws$/images/dragHandle-rotated.svg")), null)))) != null) {
            JFaceResources.getImageRegistry().put(DRAG_HANDLE_ROTATED, desc_rotated);
        }
    }

    private Image rotateImage(Display display, Image image, Integer[] frameInts) {
        if (frameInts != null) {
            int tmp = frameInts[0];
            frameInts[0] = frameInts[2];
            frameInts[2] = tmp;
            tmp = frameInts[1];
            frameInts[1] = frameInts[3];
            frameInts[3] = tmp;
        }
        if (this.rotatedImageMap.get(image) != null) {
            return this.rotatedImageMap.get(image);
        }
        Rectangle bounds = image.getBounds();
        ImageData imageData = new ImageData(bounds.height, bounds.width, 32, new PaletteData(0xFF0000, 65280, 255));
        Image rotatedImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)rotatedImage);
        RGB rgb = new RGB(125, 0, 0);
        Color offRed = new Color((Device)display, rgb);
        gc.setBackground(offRed);
        gc.fillRectangle(0, 0, bounds.height, bounds.width);
        Transform t = new Transform((Device)display);
        int w = image.getBounds().height;
        int offset = 0;
        t.translate((float)(w - offset), 0.0f);
        t.rotate(90.0f);
        gc.setTransform(t);
        gc.drawImage(image, 0, 0);
        gc.dispose();
        t.dispose();
        ImageData alphaData = rotatedImage.getImageData();
        rotatedImage.dispose();
        int transparentPix = alphaData.palette.getPixel(rgb);
        int i = 0;
        while (i < alphaData.width) {
            int j = 0;
            while (j < alphaData.height) {
                if (alphaData.getPixel(i, j) != transparentPix) {
                    alphaData.setAlpha(i, j, 255);
                }
                ++j;
            }
            ++i;
        }
        rotatedImage = new Image((Device)display, alphaData);
        this.rotatedImageMap.put(image, rotatedImage);
        return rotatedImage;
    }

    public CSSValue getCSSValue(Control styleControl, String className, String attributeName) {
        CSSStyleDeclaration styleDeclarations;
        CSSEngine csseng = WidgetElement.getEngine((Widget)styleControl);
        if (csseng == null) {
            return null;
        }
        ControlElement tempEment = (ControlElement)csseng.getElement((Object)styleControl);
        if (tempEment == null) {
            return null;
        }
        if (className != null) {
            WidgetElement.setCSSClass((Widget)styleControl, (String)className);
        }
        if ((styleDeclarations = csseng.getViewCSS().getComputedStyle((Element)tempEment, "")) == null) {
            return null;
        }
        return styleDeclarations.getPropertyCSSValue(attributeName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image createImage(Control styleControl, String classId, String attName, Integer[] frameInts) {
        CSSStyleDeclaration styleDeclarations;
        Image image = null;
        CSSEngine csseng = WidgetElement.getEngine((Widget)styleControl);
        if (csseng == null) {
            return null;
        }
        ControlElement tempEment = (ControlElement)csseng.getElement((Object)styleControl);
        if (tempEment == null) {
            return null;
        }
        if (classId != null) {
            WidgetElement.setCSSClass((Widget)styleControl, (String)classId);
        }
        if ((styleDeclarations = csseng.getViewCSS().getComputedStyle((Element)tempEment, "")) == null) {
            return null;
        }
        CSSValue imagePath = styleDeclarations.getPropertyCSSValue(attName);
        if (imagePath == null) {
            return null;
        }
        if (imagePath.getCssValueType() != 1) return image;
        try {
            image = (Image)csseng.convert(imagePath, Image.class, (Object)styleControl.getDisplay());
            if (image == null) return image;
            if (frameInts == null) return image;
            CSSValue value = styleDeclarations.getPropertyCSSValue("frame-cuts");
            if (value.getCssValueType() != 2) return image;
            CSSValueList valueList = (CSSValueList)value;
            if (valueList.getLength() != 4) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= valueList.getLength()) {
                    return image;
                }
                CSSValue val = valueList.item(i);
                if (val.getCssValueType() != 1) return null;
                if (((CSSPrimitiveValue)val).getPrimitiveType() != 5) return null;
                frameInts[i] = (int)((CSSPrimitiveValue)val).getFloatValue((short)5);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private void addHandleImageDisposedListener(ImageBasedFrame imageBasedFrame, Control toFrame, String classId, boolean vertical) {
        Listener listener = event -> {
            void frame;
            if (!(event.widget instanceof ImageBasedFrame)) {
                return;
            }
            ImageBasedFrame imageBasedFrame = (ImageBasedFrame)event.widget;
            if (!this.isImagesRefreshRequired((ImageBasedFrame)frame)) {
                return;
            }
            Image handleImage = this.createImage(toFrame, classId, HANDLE_IMAGE_PROP, null);
            if (vertical && handleImage != null) {
                Image handleImageRotated = this.createImage(toFrame, classId, HANDLE_IMAGE_ROTATE_PROP, null);
                handleImage = handleImageRotated != null ? handleImageRotated : this.rotateImage(toFrame.getDisplay(), handleImage, null);
            }
            if (handleImage != null) {
                frame.setImages(null, null, handleImage);
            }
        };
        toFrame.getDisplay().addListener(45, listener);
        imageBasedFrame.addDisposeListener(e -> e.widget.getDisplay().removeListener(45, listener));
    }

    private void addFrameImageDisposedListener(ImageBasedFrame imageBasedFrame, Control toFrame, String classId, boolean vertical) {
        Listener listener = event -> {
            void frame;
            if (!(event.widget instanceof ImageBasedFrame)) {
                return;
            }
            ImageBasedFrame imageBasedFrame = (ImageBasedFrame)event.widget;
            if (!this.isImagesRefreshRequired((ImageBasedFrame)frame)) {
                return;
            }
            Integer[] frameInts = new Integer[4];
            Image frameImage = this.createImage(toFrame, classId, FRAME_IMAGE_PROP, frameInts);
            if (vertical && frameImage != null) {
                Image frameImageRotated = this.createImage(toFrame, classId, FRAME_IMAGE_ROTATE_PROP, frameInts);
                if (frameImageRotated != null) {
                    frameImage = frameImageRotated;
                    if (frameInts != null) {
                        int tmp = frameInts[0];
                        frameInts[0] = frameInts[2];
                        frameInts[2] = tmp;
                        tmp = frameInts[1];
                        frameInts[1] = frameInts[3];
                        frameInts[3] = tmp;
                    }
                } else {
                    frameImage = this.rotateImage(toFrame.getDisplay(), frameImage, frameInts);
                }
            }
            Image handleImage = this.createImage(toFrame, classId, HANDLE_IMAGE_PROP, null);
            if (vertical && handleImage != null) {
                Image handleImageRotated = this.createImage(toFrame, classId, HANDLE_IMAGE_ROTATE_PROP, null);
                handleImage = handleImageRotated != null ? handleImageRotated : this.rotateImage(toFrame.getDisplay(), handleImage, null);
            }
            if (frameImage != null) {
                frame.setImages(frameImage, frameInts, handleImage);
            }
        };
        toFrame.getDisplay().addListener(45, listener);
        imageBasedFrame.addDisposeListener(e -> e.widget.getDisplay().removeListener(45, listener));
    }

    private boolean isImagesRefreshRequired(ImageBasedFrame frame) {
        Object handleImage = frame.getData("handleImage");
        if (handleImage instanceof Image && ((Image)handleImage).isDisposed()) {
            return true;
        }
        Object frameImage = frame.getData("frameImage");
        return frameImage instanceof Image && ((Image)frameImage).isDisposed();
    }
}

