/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

public class JUnitLaunchRequirements {
    public static final String JUNIT4_JDT_RUNTIME_PLUGIN = "org.eclipse.jdt.junit4.runtime";
    public static final String JUNIT5_JDT_RUNTIME_PLUGIN = "org.eclipse.jdt.junit5.runtime";
    private static final Comparator<IPluginModelBase> VERSION = Comparator.comparing(p -> p.getBundleDescription().getVersion());

    public static void addRequiredJunitRuntimePlugins(ILaunchConfiguration configuration, Map<String, List<IPluginModelBase>> allBundles, Map<IPluginModelBase, String> allModels) throws CoreException {
        Collection<String> runtimePlugins = JUnitLaunchRequirements.getRequiredJunitRuntimeEclipsePlugins(configuration);
        Set<BundleDescription> addedRuntimeBundles = JUnitLaunchRequirements.addAbsentRequirements(runtimePlugins, allBundles, allModels);
        Set runtimeRequirements = DependencyManager.findRequirementsClosure(addedRuntimeBundles, (DependencyManager.Options[])new DependencyManager.Options[0]);
        JUnitLaunchRequirements.addAbsentRequirements(runtimeRequirements, allBundles, allModels);
    }

    public static Collection<String> getRequiredJunitRuntimeEclipsePlugins(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind((ILaunchConfiguration)configuration);
        if (testKind.isNull()) {
            return List.of();
        }
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.add("org.eclipse.pde.junit.runtime");
        switch (testKind.getId()) {
            case "org.eclipse.jdt.junit.loader.junit4": {
                plugins.add(JUNIT4_JDT_RUNTIME_PLUGIN);
                break;
            }
            case "org.eclipse.jdt.junit.loader.junit5": {
                plugins.add(JUNIT5_JDT_RUNTIME_PLUGIN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported junit test kind: " + testKind.getId());
            }
            case "org.eclipse.jdt.junit.loader.junit3": 
        }
        return plugins;
    }

    private static Set<BundleDescription> addAbsentRequirements(Collection<String> requirements, Map<String, List<IPluginModelBase>> allBundles, Map<IPluginModelBase, String> allModels) throws CoreException {
        LinkedHashSet<BundleDescription> addedRequirements = new LinkedHashSet<BundleDescription>();
        for (String id : requirements) {
            List models = allBundles.computeIfAbsent(id, k -> new ArrayList());
            if (!models.stream().noneMatch(p -> p.getBundleDescription().isResolved())) continue;
            IPluginModelBase model = JUnitLaunchRequirements.findRequiredPluginInTargetOrHost(PluginRegistry.findModel((String)id), plugins -> plugins.max(VERSION), id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(allModels, model);
            addedRequirements.add(model.getBundleDescription());
        }
        return addedRequirements;
    }

    private static void addAbsentRequirements(Set<BundleDescription> requirements, Map<String, List<IPluginModelBase>> allBundles, Map<IPluginModelBase, String> allModels) throws CoreException {
        for (BundleRevision bundleRevision : requirements) {
            String id = bundleRevision.getSymbolicName();
            List models = allBundles.computeIfAbsent(id, k -> new ArrayList());
            if (!models.stream().map(IPluginModelBase::getBundleDescription).noneMatch(b -> b.isResolved() && b.getVersion().equals((Object)bundle.getVersion()))) continue;
            IPluginModelBase model = JUnitLaunchRequirements.findRequiredPluginInTargetOrHost(PluginRegistry.findModel((Resource)bundleRevision), plgs -> plgs.filter(p -> p.getBundleDescription() == bundle).findFirst(), id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(allModels, model);
        }
    }

    private static IPluginModelBase findRequiredPluginInTargetOrHost(IPluginModelBase model, Function<Stream<IPluginModelBase>, Optional<IPluginModelBase>> pluginSelector, String id) throws CoreException {
        if (model == null || !model.getBundleDescription().isResolved()) {
            model = pluginSelector.apply(PDECore.getDefault().findPluginInHost(id)).orElseThrow(() -> new CoreException(Status.error((String)NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)id))));
        }
        return model;
    }
}

